(function($) {

    $.su = $.su || {};
    $.su.CHAR = $.su.CHAR || {};
    $.su.CHAR.HELP = {
        STATUS_INTERNET: {
            TITLE: "Internet",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Mostra informazioni rilevanti sulla connessione Internet WAN (Wide Area Network)."
                }, {
                    type: "title",
                    title: "IPv4"
                }, {
                    type: "name",
                    title: "Indirizzo MAC",
                    content: "L'indirizzo fisico univoco assegnato alla porta Internet (WAN) del router."
                }, {
                    type: "name",
                    title: "Indirizzo IP",
                    content: "L'indirizzo IP assegnato alla porta Internet (WAN) del router. Se l'indirizzo IP viene visualizzato come 0.0.0.0, indica che non c'è alcun accesso a Internet."
                }, {
                    type: "name",
                    title: "Subnet Mask",
                    content: "Questo parametro determina la porzione di rete e la porzione host di un indirizzo IP."
                }, {
                    type: "name",
                    title: "Default Gateway",
                    content: "L'indirizzo IP utilizzato per collegare il router alla rete."
                }, {
                    type: "name",
                    title: "DNS primario/DNS secondario",
                    content: "Il Domain Name System (DNS) traduce i nomi host e i domini Internet in indirizzi IP. Le informazioni dei server DNS sono assegnate dal provider di servizi Internet (ISP)."
                }, {
                    type: "name",
                    title: "Tipo di connessione",
                    content: "Il tipo di connessione corrente della porta Internet (WAN)."
                }, {
                    type: "title",
                    title: "IPv6"
                }, {
                    type: "name",
                    title: "Indirizzo MAC",
                    content: "L'indirizzo fisico univoco assegnato alla porta Internet (WAN) del router."
                }, {
                    type: "name",
                    title: "Indirizzo IP",
                    content: "L'indirizzo IP assegnato alla porta Internet (WAN) del router."
                }, {
                    type: "name",
                    title: "Default Gateway",
                    content: "L'indirizzo IP utilizzato per collegare il router alla rete."
                }, {
                    type: "name",
                    title: "DNS primario/DNS secondario",
                    content: "Il Domain Name System (DNS) traduce i nomi host e i domini Internet in indirizzi IP. Le informazioni dei server DNS sono assegnate dal provider di servizi Internet (ISP)."
                }, {
                    type: "name",
                    title: "Tipo di connessione",
                    content: "Il tipo di connessione corrente della porta Internet (WAN)."
                }
            ]
        },
        STATUS_PLC_NTW: {
            TITLE: "Rete Powerline",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Facendo clic sull'icona delle Rete Powerline vedrete l'elenco di tutti i dispositivi powerline presenti nella rete powerline corrente."
                }
            ]
        },
        STATUS_PLC: {
            TITLE: "Powerline",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Fate clic sull'icona Powerline per vedere le informazioni relative al dispositivo powerline locale."
                }, {
                    type: "name",
                    title: "Indirizzo MAC",
                    content: "L'indirizzo fisico univoco assegnato al dispositivo powerline."
                }, {
                    type: "name",
                    title: "Chiave Powerline",
                    content: "La chiave univoca di questo dispositivo powerline che dovete utilizzare per aggiungerlo ad una rete powerline. Inoltre trovate la chiave anche sull'etichetta del prodotto."
                }, {
                    type: "name",
                    title: "Nome di Rete",
                    content: "Il nome di rete che usa il dispositivo powerline. Quello di default è HomePlugAV."
                }
            ]
        },
        STATUS_WIRELESS: {
            TITLE: "2.4GHz<span class=\"anti_5g\">/5GHz</span> Rete Wireless",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Mostra lo stato e le informazioni di base delle Rete Wireless."
                }, {
                    type: "name",
                    title: "Stato",
                    content: "Lo stato corrente (Acceso o Spento) della rete wireless."
                }, {
                    type: "name",
                    title: "Nome di rete (SSID)",
                    content: "Il nome della rete wireless, noto anche come SSID (Service Set Identifier)."
                }, {
                    type: "name",
                    title: "Canale",
                    content: "Il canale wireless corrente."
                }, {
                    type: "name",
                    title: "MAC",
                    content: "L'indirizzo MAC wireless del dispositivo powerline."
                }
            ]
        },
        STATUS_LAN: {
            TITLE: "LAN",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Mostra le informazioni relative alle porte Ethernet (LAN)."
                }, {
                    type: "title",
                    title: "IPv4"
                }, {
                    type: "name",
                    title: "Indirizzo MAC",
                    content: "L'indirizzo fisico univoco assegnato alla porta Ethernet (LAN) del router."
                }, {
                    type: "name",
                    title: "Indirizzo IP",
                    content: "L'indirizzo IPv4 assegnato alla porta Ethernet (LAN) del router."
                }, {
                    type: "name",
                    title: "Subnet Mask",
                    content: "Questo parametro determina la porzione di rete e la porzione host di un indirizzo IP."
                }, {
                    type: "name",
                    title: "DHCP",
                    content: "Mostra se il server DHCP integrato del router è attivo o non attivo per i dispositivi presenti sulle porte LAN."
                }, {
                    type: "title",
                    title: "IPv6"
                }, {
                    type: "name",
                    title: "Indirizzo MAC",
                    content: "L'indirizzo fisico univoco assegnato alla porta Ethernet (LAN) del router."
                }, {
                    type: "name",
                    title: "Indirizzo IP",
                    content: "L'indirizzo IPv6 assegnato alla porta Ethernet (LAN) del router."
                }, {
                    type: "name",
                    title: "Indirizzo locale del collegamento",
                    content: "L'indirizzo del collegamento IPv6 per l'interfaccia LAN."
                }, {
                    type: "name",
                    title: "Tipo assegnato",
                    content: "Il tipo di indirizzo IPv6 per l'interfaccia LAN."
                }
            ]
        },
        STATUS_GUEST: {
            TITLE: "2.4GHz<span class=\"anti_5g\">/5GHz</span> Rete Ospiti",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Mostra le informazioni relative alla rete wireless ospiti."
                }, {
                    type: "name",
                    title: "Stato",
                    content: "Lo stato corrente (Acceso o Spento) della rete ospiti."
                }, {
                    type: "name",
                    title: "Nome di rete (SSID)",
                    content: "Il nome di rete wireless (SSID) della rete ospiti."
                }
            ]
        },
        STATUS_USB: {
            TITLE: "Dispositivi USB",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Mostra le informazioni dei dispositivi di storage USB e/o stampanti collegati al router tramite le porte USB."
                }, {
                    type: "name",
                    title: "Stampante",
                    content: "Il nome della stampante collegata."
                }, {
                    type: "name",
                    title: "Totale",
                    content: "La capacità di storage totale del dispositivo di storage USB collegato."
                }, {
                    type: "name",
                    title: "Disponibile",
                    content: "La capacità di storage disponibile del dispositivo USB collegato. "
                }
            ]
        },
        STATUS_PERFORMANCE: {
            TITLE: "Prestazioni",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Mostra le prestazioni correnti del router."
                }, {
                    type: "name",
                    title: "Carico CPU",
                    content: "L'utilizzo corrente della CPU."
                }, {
                    type: "name",
                    title: "Utilizzo memoria",
                    content: "L'utilizzo corrente della memoria."
                }
            ]
        },
        STATUS_WIRED: {
            TITLE: "Client Cablati",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Mostra le informazioni di tutti i dispositivi cablati che sono attualmente collegati alla rete."
                }
            ]
        },
        STATUS_WIRELESS_CLIENTS: {
            TITLE: "Client Wireless",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Facendo clic sull'icona Client Wireless vedrete le informazioni relative a tutti i dispositivi wireless collegati alla rete wireless creata dal dispositivo powerline."
                }, {
                    type: "name",
                    title: "MAC Address",
                    content: "L'indirizzo MAC del client wireless."
                }, {
                    type: "name",
                    title: "Frequenza Wireless",
                    content: "La frequenza wireless <span class=\"anti_5g\">(2.4GHz o 5GHz) </span>alla quale è connesso il client."
                }
            ]
        },
        STATUS_WIFI_MOVE: {
            TITLE: "Wi-Fi Move",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Indica se la funzione Wi-Fi Move è abilitata."
                }
            ]
        },
        INTERNET_INTERNET: {
            TITLE: "IPv4",
            CONTENT: [
                {
                    type: "title",
                    title: "Tipo di connessione Internet: IP Statico"
                }, {
                    type: "paragraph",
                    content: "Selezionate questo tipo se siete in possesso di un Indirizzo IP specifico (fisso), Subnet Mask, Gateway e parametri DNS forniti dall'ISP."
                }, {
                    type: "name",
                    title: "Indirizzo IP/Subnet mask/Gateway predefinito/DNS primario/DNS secondario",
                    content: "Immettete le informazioni fornite dall'ISP."
                }, {
                    type: "name",
                    title: "Dimensione MTU",
                    content: "La dimensione tipica di default della MTU (Maximum Transmission Unit) della maggior parte delle reti Ethernet è 1.500 Byte. Consigliamo di NON cambiare la dimensione MTU predefinita se non richiesto dall'ISP."
                }, {
                    type: "title",
                    title: "Tipo di connessione Internet: IP dinamico"
                }, {
                    type: "paragraph",
                    content: "Selezionate questo tipo se utilizzate una connessione al server DHCP fornita dall'ISP."
                }, {
                    type: "name",
                    title: "Indirizzo IP/Subnet mask/Gateway predefinito/DNS primario/DNS secondario",
                    content: "Questi parametri vengono assegnati automaticamente dal server DHCP dell'ISP."
                }, {
                    type: "name",
                    title: "Rinnova",
                    content: "Fate clic sul pulsante per ottenere nuovi parametri IP dal server DHCP."
                }, {
                    type: "name",
                    title: "Rilascia",
                    content: "Fate clic sul pulsante per rilasciare tutti gli indirizzi IP assegnati dal server DHCP."
                }, {
                    type: "name",
                    title: "Utilizza i seguenti indirizzi DNS",
                    content: "Se l'ISP fornisce uno o due indirizzi DNS, selezionate la casella di controllo e immettete gli indirizzi DNS primario e secondario nei campi corrispondenti. In caso contrario, gli indirizzi DNS verranno assegnati dinamicamente dall'ISP."
                }, {
                    type: "name",
                    title: "Dimensione MTU",
                    content: "La dimensione tipica di default della MTU (Maximum Transmission Unit) della maggior parte delle reti Ethernet è 1.500 Byte. Consigliamo di NON cambiare la dimensione MTU predefinita se non richiesto dall'ISP."
                }, {
                    type: "name",
                    title: "Nome host",
                    content: "Immettete un valore in questo campo per specificare il nome host del router."
                }, {
                    type: "name",
                    title: "Ottieni IP utilizzando DHCP unicast",
                    content: "Selezionate questa casella di controllo se il server DHCP dell'ISP non supporta le applicazioni broadcast e non è possibile ottenere l'indirizzo IP in modo dinamico."
                }, {
                    type: "note",
                    title: "Nota",
                    content: "Se trovate l'errore “Indirizzo non trovato” dopo che avete immesso gli indirizzi DNS, è probabile che abbiate impostato in modo non corretto i server DNS; contattate l'ISP per ricevere assistenza."
                }, {
                    type: "title",
                    title: "Tipo di connessione Internet: PPPoE"
                }, {
                    type: "paragraph",
                    content: "Selezionate questo tipo se utilizzate il servizio DSL (Digital Subscriber Line) e disponete di un nome utente e una password forniti dall'ISP."
                }, {
                    type: "name",
                    title: "Username/Password",
                    content: "Immettete il nome utente e la password forniti dall'ISP. I campi fanno distinzione tra maiuscole e minuscole."
                }, {
                    type: "name",
                    title: "Indirizzo IP/DNS primario/DNS secondario",
                    content: "Questi parametri vengono assegnati automaticamente dal server DHCP dell'ISP."
                }, {
                    type: "name",
                    title: "Connessione Secondaria (Nessuna, IP Dinamico, IP Statico)",
                    children: [
                        {
                            type: "name",
                            title: "Nessuna",
                            content: "Selezionate se non viene fornita alcuna connessione secondaria."
                        }, {
                            type: "name",
                            title: "IP dinamico",
                            content: "Selezionate se l'indirizzo IP e la subnet mask vengono assegnati automaticamente dall'ISP.",
                            children: [
                                {
                                    type: "name",
                                    title: "Rinnova",
                                    content: "Fate clic sul pulsante per rinnovare i parametri IP forniti dall'ISP."
                                }, {
                                    type: "name",
                                    title: "Rilascia",
                                    content: "Fate clic sul pulsante per rilasciare i parametri IP assegnati."
                                }
                            ]
                        }, {
                            type: "name",
                            title: "IP statico",
                            content: "Selezionate se indirizzo IP, Subnet Mask, Gateway e indirizzi DNS sono forniti dall'ISP, e immettete queste informazioni nei campi corrispondenti."
                        }
                    ]
                }, {
                    type: "name",
                    title: "Dimensione MTU",
                    content: "La dimensione tipica dell'MTU (Maximum Transmission Unit) delle reti Ethernet è 1.480 byte.",
                    children: [
                        {
                            type: "note",
                            title: "Nota",
                            content: "In rari casi l'ISP può richiedere di modificare la dimensione MTU per migliorare le prestazioni della rete. Vi consigliamo di non modificare il valore, a meno che non sia assolutamente necessario."
                        }
                    ]
                }, {
                    type: "name",
                    title: "Nome servizio/Nome Concentratore Accessi",
                    content: "Di default, Nome servizio e Nome Concentratore Accessi (AC) vengono lasciati vuoti. Questi campi non devono essere configurati se non richiesto dal proprio ISP."
                }, {
                    type: "name",
                    title: "Rileva Intervallo Online",
                    content: "Immettete il valore dell'intervallo, compreso tra 0 e 120 (in secondi), che determina ogni quanto il router rileva Concentratore Accessi online. Il valore di default è 0, che significa nessuna rilevazione."
                }, {
                    type: "name",
                    title: "Indirizzo IP",
                    content: "Se l'ISP fornisce un indirizzo IP specifico (fisso), selezionate Utilizza il seguente indirizzo IP e immettete l'indirizzo IP nel campo. In caso contrario, selezionate Ottieni dinamicamente da ISP per ottenere automaticamente un indirizzo IP assegnato dal server."
                }, {
                    type: "name",
                    title: "Indirizzo DNS/DNS primario/DNS secondario",
                    content: "Se l'ISP fornisce indirizzi IP DNS specifici (fissi), selezionate Utilizza il seguente indirizzo DNS e immettete gli indirizzi rispettivamente nei campi DNS primario e DNS secondario. In caso contrario, selezionate Ottieni dinamicamente da ISP per ottenere automaticamente gli indirizzi IP DNS assegnati dal server. "
                }, {
                    type: "name",
                    title: "Modalità di connessione",
                    content: "Selezionate una modalità di connessione appropriata per l'accesso a Internet.",
                    children: [
                        {
                            type: "name",
                            title: "Auto",
                            content: "In questa modalità, la connessione a Internet viene ristabilita automaticamente dopo ogni disconnessione."
                        }, {
                            type: "name",
                            title: "Su richiesta",
                            content: "In questa modalità, la connessione Internet viene terminata automaticamente dopo un periodo di tempo di inattività specificato (Max Idle Time). La connessione verrà ristabilita quando  tenterete di accedere nuovamente a Internet."
                        }, {
                            type: "name",
                            title: "Basata sul tempo",
                            content: "In questa modalità, la connessione Internet viene stabilita solo in un periodo di tempo specifico. Se l'opzione è selezionata, immettete ora di inizio e di fine in formato OO:MM."
                        }, {
                            type: "name",
                            title: "Manualmente",
                            content: "In questa modalità, la connessione a Internet è controllata manualmente facendo clic sul pulsante Connetti o Disconnetti. Questa modalità supporta anche la funzione Max Idle Time. Nel campo Max Idle Time immettete il tempo massimo (in minuti) di inattività della connessione a Internet prima che venga terminata. Il valore di default è 15 minuti. Se desiderate che la connessione a Internet rimanga sempre attiva, immettete 0 (zero)."
                        }, {
                            type: "note",
                            title: "Nota",
                            content: "La modalità di connessione basata sul tempo avrà effetto solo se l'Ora di Sistema è impostata su Avanzate → Utilità di sistema → Impostazioni data/ora."
                        }
                    ]
                }, {
                    type: "title",
                    title: "Tipo di connessione Internet: cavo BigPond"
                }, {
                    type: "paragraph",
                    content: "Selezionate questo tipo se l'ISP fornisce una connessione tramite cavo BigPond."
                }, {
                    type: "name",
                    title: "Nome utente/password",
                    content: "Immettete nome utente e password forniti dall'ISP. I campi fanno distinzione tra maiuscole e minuscole."
                }, {
                    type: "name",
                    title: "Server di autenticazione",
                    content: "Immettete l'indirizzo IP o hostname del server di autenticazione."
                }, {
                    type: "name",
                    title: "Dominio di autenticazione",
                    content: "Immettete il suffisso del nome di dominio del server (in base alla posizione geografica).  Ad esempio, nsw.bigpond.net.au per  NSW/ACT, vic.bigpond.net.au per  VIC/TAS/WA/SA/NT, o qld.bigpond.net.au per QLD."
                }, {
                    type: "name",
                    title: "Dimensione MTU",
                    content: "La dimensione tipica di default della MTU (Maximum Transmission Unit) della maggior parte delle reti Ethernet è 1.500 Byte. Consigliamo di NON cambiare la dimensione MTU predefinita se non richiesto dall'ISP."
                }, {
                    type: "name",
                    title: "Modalità di connessione",
                    content: "Selezionate una modalità di connessione appropriata per l'accesso a Internet.",
                    children: [
                        {
                            type: "name",
                            title: "Auto",
                            content: "In questa modalità, la connessione a Internet viene ristabilita automaticamente dopo ogni disconnessione."
                        }, {
                            type: "name",
                            title: "Su richiesta",
                            content: "In questa modalità, la connessione Internet viene terminata automaticamente dopo un periodo di tempo di inattività specificato (Max Idle Time). La connessione verrà ristabilita quando  tenterete di accedere nuovamente a Internet."
                        }, {
                            type: "name",
                            title: "Manualmente",
                            content: "In questa modalità, la connessione a Internet è controllata manualmente facendo clic sul pulsante Connetti o Disconnetti. Questa modalità supporta anche la funzione Max Idle Time. Nel campo Max Idle Time immettete il tempo massimo (in minuti) di inattività della connessione a Internet prima che venga terminata. Il valore di default è 15 minuti. Se desiderate che la connessione a Internet rimanga sempre attiva, immettete 0 (zero)."
                        }
                    ]
                }, {
                    type: "title",
                    title: "Tipo di connessione Internet: L2TP/PPTP"
                }, {
                    type: "paragraph",
                    content: "Selezionate questo tipo se vi connettete a un server VPN L2TP/PPTP e disponete di nome utente, password e indirizzo IP/nome di dominio del server forniti dall'ISP."
                }, {
                    type: "name",
                    title: "Username/Password",
                    content: "Immettete nome utente e password forniti dall'ISP. I campi fanno distinzione tra maiuscole e minuscole."
                }, {
                    type: "name",
                    title: "Indirizzo IP/DNS primario/DNS secondario",
                    content: "Questi parametri vengono assegnati automaticamente dal server DHCP dell'ISP."
                }, {
                    type: "name",
                    title: "Connessione secondaria (IP dinamico o statico)",
                    children: [
                        {
                            type: "name",
                            title: "IP dinamico",
                            content: "Selezionate se l'indirizzo IP e la subnet mask vengono assegnati automaticamente dall'ISP.",
                            children: [
                                {
                                    type: "name",
                                    title: "Rinnova",
                                    content: "Fate clic sul pulsante per rinnovare i parametri IP forniti dall'ISP."
                                }, {
                                    type: "name",
                                    title: "Rilascia",
                                    content: "Fate clic sul pulsante per rilasciare i parametri IP assegnati."
                                }
                            ]
                        }, {
                            type: "name",
                            title: "IP statico",
                            content: "Selezionate se indirizzo IP, subnet mask, gateway e indirizzi DNS sono forniti dall'ISP, e immettete le informazioni nei campi corrispondenti."
                        }
                    ]
                }, {
                    type: "name",
                    title: "IP/nome di dominio server VPN",
                    content: "Immettete indirizzo IP o nome di dominio del server VPN fornito dall'ISP."
                }, {
                    type: "name",
                    title: "Dimensione MTU",
                    content: "La tipica dimensione di default della MTU (Maximum Transmission Unit) della maggior parte delle reti Ethernet è 1.460 byte. Consigliamo di NON cambiare la dimensione MTU predefinita se non richiesto dall'ISP."
                }, {
                    type: "name",
                    title: "Modalità di connessione",
                    content: "Selezionate una modalità di connessione appropriata per l'accesso a Internet.",
                    children: [
                        {
                            type: "name",
                            title: "Auto",
                            content: "In questa modalità, la connessione a Internet viene ristabilita automaticamente dopo ogni disconnessione."
                        }, {
                            type: "name",
                            title: "Su richiesta",
                            content: "In questa modalità, la connessione Internet viene terminata automaticamente dopo un periodo di tempo di inattività specificato (Max Idle Time). La connessione verrà ristabilita quando  tenterete di accedere nuovamente a Internet."
                        }, {
                            type: "name",
                            title: "Manuale",
                            content: "In questa modalità, la connessione a Internet è controllata manualmente facendo clic sul pulsante Connetti o Disconnetti. Questa modalità supporta anche la funzione Max Idle Time. Nel campo Max Idle Time immettete il tempo massimo (in minuti) di inattività della connessione a Internet prima che venga terminata. Il valore di default è 15 minuti. Se desiderate che la connessione a Internet rimanga sempre attiva, immettete 0 (zero)."
                        }
                    ]
                }
            ]
        },
        HELP_PLC_STATION: {
            TITLE: "Elenco Dispositivi Powerline",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Mostra le informazioni relative a tutti i dispositivi powerline presenti nella stessa rete del medesimo impianto elettrico."
                }, {
                    type: "name",
                    title: "Dispositivo Locale",
                    content: "Il dispositivo powerline cui siete attualmente loggati."
                }, {
                    type: "step",
                    content: ["Nella lista dei dispositivi powerline, indirizzo MAC e livello di trasmissione dati di ogni dispositivo sono mostrati da sinistra a destra.", "Fate clic sull'icona <b>Cestino</b> per rimuovere dalla rete il dispositivo powerline corrispondente.", "Fate clic sull'icona <b>Aggiungi</b> per aggiungere alla rete powerline un nuovo dispositivo powerline usando la sua password."]
                }, {
                    type: "name",
                    title: "Indietro",
                    content: "Fate clic per tornare alla pagina Stato."
                }, {
                    type: "name",
                    title: "Aggiorna",
                    content: "Fate clic per aggiornare la pagina."
                }
            ]
        },
        INTERNET_MAC: {
            TITLE: "MAC Clone",
            CONTENT: [
                {
                    type: "name",
                    title: "Utilizza indirizzo MAC di Default",
                    content: "NON modificate l'indirizzo MAC di default del router, per evitare l'insorgere di problemi nel caso in cui l'ISP vincoli l'indirizzo IP assegnato all'indirizzo MAC."
                }, {
                    type: "name",
                    title: "Utilizza indirizzo MAC computer corrente",
                    content: "Selezionate per copiare l'indirizzo MAC corrente del computer connesso al router, nel caso in cui l'ISP vincoli l'indirizzo IP assegnato all'indirizzo MAC del computer."
                }, {
                    type: "name",
                    title: "Utilizza indirizzo MAC personalizzato",
                    content: "Immettete l'indirizzo MAC manualmente, nel caso in cui l'ISP vincoli l'indirizzo IP assegnato a un indirizzo MAC specifico."
                }
            ]
        },
        LAN_IPV4: {
            TITLE: "Impostazioni LAN",
            CONTENT: [
                {
                    type: "name",
                    title: "Tipo LAN",
                    content: "Selezionate IP Dinamico o IP Statico."
                }, {
                    type: "name",
                    title: "IP Dinamico",
                    content: "Selezionate questa opzione per ottenere automaticamente un indirizzo IP dal server DHCP."
                }, {
                    type: "name",
                    title: "IP Statico",
                    content: "Selezionate questa opzione se indicate manualmente indirizzo IP, subnet mask e default gateway."
                }, {
                    type: "name",
                    title: "Indirizzo IP",
                    content: "Mostra l'indirizzo IP di default del dispositivo powerline che viene utilizzato per accedere alla sua pagina di gestione Web."
                }, {
                    type: "name",
                    title: "Subnet Mask",
                    content: "Selezionate un identificativo assegnato utilizzato dalla porta LAN per instradare il traffico interno e esterno dall'elenco a discesa o inserite una nuova subnet mask in formato decimale puntato."
                }, {
                    type: "name",
                    title: "Default Gateway",
                    content: "L'indirizzo IP usato per collegare il dispositivo powerline alla rete."
                }, {
                    type: "paragraph",
                    content: "Fate clic su <b>Salva</b> per salvare tutte le vostre impostazioni."
                }
            ]
        },
        LED_TIME: {
            TITLE: "Schedulazione LED",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "La schedulazione LED vi permette di accendere o spegnere i LED di questo dispositivo powerline in base ad una specifica schedulazione temporale."
                }, {
                    type: "name",
                    title: "Schedulazione LED",
                    content: "Spostate su <b>Acceso</b> per abilitare la funzione Schedulazione LED."
                }
            ]
        },
        LED_TIME_GRID: {
            TITLE: "Schedulazione Spegnimento LED",
            CONTENT: [
                {
                    type: "name",
                    title: "Da",
                    content: "Mostra l'ora a partire dalla quale i LED si spengono."
                }, {
                    type: "name",
                    title: "A",
                    content: "Mostra l'ora a partire dalla quale i LED si accendono."
                }, {
                    type: "name",
                    title: "Giorni",
                    content: "Mostra i giorni effettivi di schedulazione."
                }, {
                    type: "name",
                    title: "Stato",
                    content: "Indica lo stato corrente della schedulazione corrispondente. Fate clic sull'icona <b>Lampadina</b> per abilitare o disabilitare la schedulazione."
                }, {
                    type: "name",
                    title: "Modifica",
                    content: "Mostra le opzioni <b>Modifica</b> o <b>Elimina</b> per la schedulazione corrispondente."
                }, {
                    type: "step",
                    title: "Per creare una nuova schedulazione",
                    content: ["1. Fate clic su <b>Aggiungi</b>.", "2. Specificate un periodo di tempo durante il quale i LED saranno spenti.", "3. Selezionate i giorni della settimana nei quali la schedulazione è attiva.", "4. Selezionate <b>Abilita questa riga</b>.", "5. Fate clic su <b>OK</b> per salvare le impostazioni."]
                }, {
                    type: "paragraph",
                    content: "Per modificare o eliminare una schedulazione, fate clic sull'icona <b>Edita</b> per editare le informazioni o sull'icona <<b>Cestino</b> per eliminare la schedulazione corrispondente."
                }, {
                    type: "paragraph",
                    content: "Per eliminare più schedulazioni, selezionate le caselle di controllo delle schedulazioni che volete eliminare e fate clic su <b>Elimina</b> sopra la tabella."
                }
            ]
        },
        HELP_PLC: {
            TITLE: "Powerline",
            CONTENT: [
                {
                    type: "name",
                    title: "Indirizzo MAC",
                    content: "L'indirizzo fisico univoco assegnato al dispositivo powerline."
                }, {
                    type: "name",
                    title: "Chiave Powerline",
                    content: "La chiave univoca di questo dispositivo powerline che dovete utilizzare per aggiungerlo ad una rete powerline. Inoltre trovate la chiave anche sull'etichetta del prodotto."
                }, {
                    type: "name",
                    title: "Nome di Rete",
                    content: "Mostra il nome di rete cui appartiene il dispositivo powerline. Qui potete rinominare la rete o fare clic su Default per riportare il nome alle impostazioni di fabbrica di default, es. HomePlugAV. Fate attenzione che se il nome di default è già utilizzato, la funzione Wi-Fi Move verrà automaticamente disabilitata."
                }
            ]
        },
        IPTV: {
            TITLE: "Impostazioni",
            CONTENT: [
                {
                    type: "name",
                    title: "IPTV",
                    content: "Selezionate per attivare la funzione IPTV."
                }, {
                    type: "name",
                    title: "Modalità",
                    content: "Selezionate la modalità appropriata in base all'ISP. Sono supportate 6 modalità IPTV:",
                    children: [
                        {
                            type: "name",
                            title: "Bridge",
                            content: "Se l'ISP non compare nell'elenco e non servono altri parametri, potete semplicemente selezionare questa modalità e configurare le funzioni della porta LAN del router.",
                            children: [
                                {
                                    type: "name",
                                    title: "LAN 1/2/3/4",
                                    content: "Assegnate alla porta LAN la funzione di provider Internet o provider IPTV."
                                }
                            ]
                        }, {
                            type: "name",
                            title: "Russia",
                            content: "Selezionate se il proprio ISP è russo e i parametri necessari sono predeterminati, compresi Internet/telefono IP/ID e priorità VLAN IPTV e porta LAN (1/2/3/4).",
                            children: [
                                {
                                    type: "name",
                                    title: "ID VLAN multicast IPTV/Priorità",
                                    content: "Potete attivare la funzionalità multicast IPTV e configurare l'ID VLAN e la priorità secondo le indicazioni dell'ISP."
                                }
                            ]
                        }, {
                            type: "name",
                            title: "Singapore-ExStream",
                            content: "Selezionate se il proprio ISP è ExStream di Singapore e i parametri necessari sono predeterminati, compresi Internet/ID e priorità VLAN IPTV e porta LAN (1/2/3/4)."
                        }, {
                            type: "name",
                            title: "Malaysia-Unifi",
                            content: "Selezionate se il proprio ISP è Unifi Malaysia e i parametri necessari sono predeterminati, compresi Internet/ID VLAN e priorità e porta LAN (1/2/3/4)."
                        }, {
                            type: "name",
                            title: "Malaysia-Maxis",
                            content: "Selezionate se il proprio ISP è Maxis Malaysia e i parametri necessari sono predeterminati, compresi Internet/telefono IP/ID e priorità VLAN IPTV e porta LAN (1/2/3/4). "
                        }, {
                            type: "name",
                            title: "Personalizzato",
                            content: "Selezionate se il proprio ISP non è elencato ma fornisce i parametri necessari, compresi  Internet/IP-Phone/IPTV VLAN ID e Priorità, caratteristiche porta LAN (1/2/3/4). ",
                            children: [
                                {
                                    type: "name",
                                    title: "Internet/Telefono IP/ID VLAN IPTV/ Priorità",
                                    content: "Configurate ID e priorità VLAN come previsto dal vostro ISP."
                                }, {
                                    type: "name",
                                    title: "Tag 802.11Q",
                                    content: "Selezionate per taggare i pacchetti Internet con 802.11Q."
                                }, {
                                    type: "name",
                                    title: "ID VLAN multicast IPTV/Priorità",
                                    content: "Potete attivare la funzionalità multicast IPTV e configurare l'ID VLAN e la priorità secondo le indicazioni dell'ISP."
                                }, {
                                    type: "name",
                                    title: "LAN 1/2/3/4",
                                    content: "Assegnate alla porta LAN la funzione di provider Internet, di telefonia IP o IPTV."
                                }
                            ]
                        }
                    ]
                }, {
                    type: "name",
                    title: "Proxy IGMP",
                    content: "Selezionate la versione proxy IGMP (Internet Group Management Protocol), V2 o V3, secondo le indicazioni dell'ISP."
                }
            ]
        },
        DHCP_SERVER_SETTINGS: {
            TITLE: "Impostazioni",
            CONTENT: [
                {
                    type: "name",
                    title: "Server DHCP",
                    content: "Di default il server DHCP (Dynamic Host Configuration Protocol) è abilitato; assegna in modo dinamico i parametri TCP/IP ai dispositivi client dal pool di indirizzi IP. NON disabilitate il server DHCP a meno che non disponiate di un altro server DHCP o desideriate assegnare manualmente i parametri TCP/IP ad ogni dispositivo client della rete."
                }, {
                    type: "name",
                    title: "Pool di indirizzi IP",
                    content: "Immettete l'intervallo di indirizzi IP che possono essere assegnati ai client. "
                }, {
                    type: "name",
                    title: "Durata lease indirizzo",
                    content: "Immettete la durata di un indirizzo IP al client, che deve essere compresa tra 2 ei 2.880 minuti. Il valore di default è 120 minuti."
                }, {
                    type: "name",
                    title: "Gateway predefinito",
                    content: "Immettete l'indirizzo IP della LAN (facoltativo)."
                }, {
                    type: "name",
                    title: "DNS primario/DNS secondario",
                    content: "Immettete i parametri forniti dall'ISP. (facoltativo)."
                }
            ]
        },
        RESERVED_IP_ADDRESS: {
            TITLE: "Riserva Indirizzi",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Potete riservare manualmente un indirizzo IP per un client che si connette al router. Una volta riservato, l'indirizzo IP verrà assegnato dal server DHCP sempre allo stesso client."
                }, {
                    type: "name",
                    title: "Indirizzo MAC",
                    content: "Mostra l'indirizzo MAC del client con indirizzo IP DHCP riservato."
                }, {
                    type: "name",
                    title: "Indirizzo IP riservato",
                    content: "Mostra l'indirizzo IP riservato del client."
                }, {
                    type: "name",
                    title: "Descrizione",
                    content: "Mostra una descrizione del dispositivo client."
                }, {
                    type: "name",
                    title: "Stato",
                    content: "Mostra lo stato corrente (abilitato o disabilitato) del dispositivo client. "
                }, {
                    type: "name",
                    title: "Modifica",
                    content: "Mostra le opzioni per modificare o eliminare il client corrispondente."
                }, {
                    type: "step",
                    title: "Per prenotare un indirizzo IP",
                    content: [
                        "1. Fate clic su Aggiungi.",
                        "2. Immettete l'indirizzo MAC del client desiderato.",
                        "3. Immettete l'indirizzo IP che desiderate riservare per il client.",
                        "4. Immettete una descrizione del client.",
                        "5. Selezionate Abilita.",
                        "6. Fate clic su OK."
                    ]
                }, {
                    type: "step",
                    title: "Per modificare o eliminare un client esistente",
                    content: "Nella tabella, fate clic su Modifica o su Elimina per modificare o eliminare il dispositivo corrispondente. "
                }
            ]
        },
        DHCP_CLIENT_LIST: {
            TITLE: "Elenco Client DHCP",
            CONTENT: [
                {
                    type: "name",
                    title: "Numero client",
                    content: "Mostra il numero di client DHCP associati."
                }, {
                    type: "name",
                    title: "Nome client",
                    content: "Mostra il nome del client DHCP."
                }, {
                    type: "name",
                    title: "Indirizzo MAC",
                    content: "Mostra l'indirizzo MAC."
                }, {
                    type: "name",
                    title: "Indirizzo IP assegnato",
                    content: "Mostra l'indirizzo IP assegnato al client dal server DHCP."
                }, {
                    type: "name",
                    title: "Durata del lease",
                    content: "Mostra la durata rimanente dell'indirizzo IP del client."
                }, {
                    type: "name",
                    title: "Aggiorna",
                    content: "Fate clic per aggiornare l'elenco DHCP Client."
                }
            ]
        },
        DDNS: {
            TITLE: "DNS Dinamico",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "DNS dinamico (DDNS) consente di assegnare un host e un nome di dominio fissi a un indirizzo IP Internet dinamico. È utile se effettuate l'host dei vostri sito Web, server FTP o un altro server dietro il router. In primo luogo è necessario registrarsi con un provider di servizi DDNS, come www.dyndns.com."
                }, {
                    type: "step",
                    title: "Per impostare un DNS dinamico",
                    content: ["1. Selezionate il provider di servizi DDNS.", "2. Immettete il nome utente e la password dell'account DDNS.", "3. Immettete il nome di dominio ricevuto dal provider di servizi DDNS.", "4. Selezionate l'Intervallo di Aggiornamento dall'elenco a discesa.", "5. Fate clic su Login e Salva."]
                }, {
                    type: "paragraph",
                    content: "Per passare da un account all'altro è necessario dapprima disconnettersi dall'account corrente, quindi accedere all'altro account con i nuovi nome utente e password. "
                }
            ]
        },
        ADVANCED_ROUTING_STATIC_ROUTING: {
            TITLE: "Routing Statico",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Il routing statico viene utilizzato per predeterminare un percorso fisso per i pacchetti di informazioni di rete per raggiungere un host o una rete specifica."
                }, {
                    type: "step",
                    title: "Per impostare un routing statico",
                    content: [
                        "1. Fate clic su Aggiungi.",
                        "2. Rete di destinazione - Immettete un indirizzo IP in formato decimale puntato per assegnare il percorso statico a questa voce.",
                        "3. Subnet mask - Immettete una subnet mask in formato decimale puntato per determinare la porzione di rete e di host dell'indirizzo IP.",
                        "4. Default Gateway - Immettete un indirizzo IP gateway in formato decimale puntato per collegare il router alla rete o all'host.",
                        "5. Interfaccia - Selezionate LAN o WAN per specificare il tipo di rete di destinazione.",
                        "6. Descrizione - Immettete una breve descrizione di questa voce.",
                        "7. Selezionate Abilita.",
                        "8. Fate clic su OK."
                    ]
                }, {
                    type: "step",
                    title: "Per modificare o eliminare un voce esistente",
                    content: "Nella tabella, fate clic sull'icona Edita o Elimina per modificare o eliminare la voce corrispondente."
                }
            ]
        },
        ADVANCED_ROUTING_SYSTEM_ROUTING: {
            TITLE: "Tabella Routing di Sistema",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "La tabella di routing del sistema mostra tutte le voci delle route valide attualmente in uso."
                }, {
                    type: "paragraph",
                    content: "Fate clic su Aggiorna per aggiornare la tabella di routing."
                }
            ]
        },
        WIRELESS_REGION: {
            TITLE: "Impostazioni",
            CONTENT: [
                {
                    type: "name",
                    title: "Regione",
                    content: "Selezionate la regione dal menu a discesa. Se i vostri paese o regione non sono presenti, potrebbe non essere possibile utilizzare il wireless in quel paese."
                }, {
                    type: "paragraph",
                    content: "Fate clic su S<b>Salva</b> per salvare tutte le impostazioni."
                }
            ]
        },
        WIRELESS_BOTH: {
            TITLE: "Wireless",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Le seguenti istruzioni sono valide <span class=\"anti_5g\"> per le reti wireless sia 2.4GHz che 5GHz </span>."
                }, {
                    type: "name",
                    title: "Abilita Wireless",
                    content: "Selezionate la casella di controllo per abilitare il wireless."
                }, {
                    type: "name",
                    title: "Nome di rete wireless (SSID)",
                    content: "Potete lasciare il nome di default della rete (SSID), oppure immettere un nuovo nome (fino a 32 caratteri). Il campo fa distinzione tra maiuscole e minuscole."
                }, {
                    type: "name",
                    title: "Nascondi SSID",
                    content: "Selezionate la casella se desiderate nascondere il nome della rete wireless (SSID) dall'elenco delle reti Wi-Fi."
                }, {
                    type: "name",
                    title: "Password",
                    content: "Create una password wireless composta di 8-63 caratteri ASCII, o 8-64 caratteri esadecimali per rendere sicura la rete wireless."
                }, {
                    type: "name",
                    title: "Avanzate",
                    content: "Fate clic per vedere le impostazioni avanzate."
                }, {
                    type: "name",
                    title: "Sicurezza",
                    content: "Selezionate una delle seguenti opzioni di sicurezza:",
                    children: [
                        {
                            type: "name",
                            title: "Nessuna sicurezza",
                            content: "Selezionate l'opzione per disabilitare la sicurezza wireless. Vi <b> consigliamo </b> di abilitare la sicurezza wireless per proteggere la rete wireless da accessi non autorizzati."
                        }, {
                            type: "name",
                            title: "WPA/WPA2-Personal",
                            content: "Selezionate l'opzione per abilitare il metodo di autenticazione standard basato sull'utilizzo di una chiave precondivisa (PSK), detta anche passphrase. Opzione consigliata. Se selezionata, configurate quanto segue.",
                            children: [
                                {
                                    type: "name",
                                    title: "Versione",
                                    content: "Selezionate una versione di sicurezza per la rete wireless.",
                                    children: [
                                        {
                                            type: "name",
                                            title: "Auto",
                                            content: "L'opzione supporta implementazioni multiple del WPA (Wi-Fi Protected Access) standard, come WPA e WPA2."
                                        }, {
                                            type: "name",
                                            title: "WPA-PSK",
                                            content: "L'opzione supporta solo la crittografia TKIP che offre un buon livello di sicurezza."
                                        }, {
                                            type: "name",
                                            title: "WPA2-PSK",
                                            content: "L'opzione supporta la crittografia AES che garantisce un miglior livello di sicurezza rispetto a WPA-PSK ed è consigliata."
                                        }
                                    ]
                                }, {
                                    type: "name",
                                    title: "Crittografia",
                                    content: "Selezionate un tipo di crittografia di sicurezza: <b>TKIP</b> (Temporal Key Integrity Protocol),  <b>AES</b> (Advanced Encryption Standard), o <b>Automatica</b> (per TKIP e AES). Consigliamo di <b>NON</b> utilizzare la crittografia TKIP se il router funziona in modalità 802.11n, perché non è supportata dalle specifiche 802.11n. Se selezionate TKIP, la funzione WPS sarà disabilitata."
                                }
                            ]
                        }, {
                            type: "name",
                            title: "WEP",
                            content: "Selezionate l'opzione per abilitare il metodo di autenticazione di base se uno dei dispositivi client può accedere alla rete wireless solo utilizzando il protocollo WEP (Wired Equivalent Privacy).",
                            children: [
                                {
                                    type: "name",
                                    title: "Tipo",
                                    content: "Selezionate un tipo di autenticazione per la rete wireless. Il valore di default è <b>Automatica</b>, che sceglie automaticamente tra <b>Open System</b> o <b>Shared Key</b> in base alla capacità e alla richiesta di accesso del client wireless."
                                }, {
                                    type: "name",
                                    title: "Chiave Selezionata",
                                    content: "Selezionate una delle 4 chiavi."
                                }, {
                                    type: "name",
                                    title: "Formato chiave WEP",
                                    content: "Utilizzate il formato <b>ASCII</b> o <b>Esadecimale</b>. Il formato ASCII è una combinazione di caratteri alfabetici e numerici. Il formato esadecimale è una combinazione di numeri (0-9) e lettere (A-F, a-f)."
                                }, {
                                    type: "name",
                                    title: "Tipo di chiave",
                                    content: "Selezionate la lunghezza della chiave WEP.",
                                    children: [
                                        {
                                            type: "name",
                                            title: "64 bit",
                                            content: "Permette di inserire 10 cifre esadecimali (0-9, A-F, a-f) o 5 caratteri ASCII nel campo password."
                                        }, {
                                            type: "name",
                                            title: "128 bit",
                                            content: "Permette di inserire 26 cifre esadecimali (0-9, A-F, a-f) o 13 caratteri ASCII nel campo password."
                                        }
                                    ]
                                }
                            ]
                        }
                    ]
                }, {
                    type: "name",
                    title: "Modalità",
                    content: "Selezionate una modalità di trasmissione mista."
                }, {
                    type: "name",
                    title: "Larghezza canale",
                    content: "Selezionate l'ampiezza di canale per la rete wireless corrispondente."
                }, {
                    type: "name",
                    title: "Canale",
                    content: "Selezionate un canale operativo per la rete wireless corrispondente. Se non si verificano problemi di instabilità wireless, vi consigliamo di lasciare l'impostazione <b>Auto</b>."
                }, {
                    type: "name",
                    title: "Potenza di trasmissione",
                    content: "Selezionate <b>Alta</b>, <b>Media</b>, o <b>Bassa</b> per specificare la potenza di trasmissione dati. L'impostazione predefinita e consigliata è <b>Alta</b>."
                }, {
                    type: "paragraph",
                    content: "Fate clic su <b>Salva</b> per salvare tutte le impostazioni."
                }
            ]
        },
        WIRELESS_24G: {
            TITLE: "Wireless 2.4GHz",
            CONTENT: [
                {
                    type: "name",
                    title: "Abilita Wireless",
                    content: "Selezionate la casella di controllo per abilitare il wireless 2.4GHz."
                }, {
                    type: "name",
                    title: "Nome di rete wireless (SSID)",
                    content: "Potete lasciare il nome di default della rete (SSID), oppure immettere un nuovo nome (fino a 32 caratteri). Il campo fa distinzione tra maiuscole e minuscole."
                }, {
                    type: "name",
                    title: "Nascondi SSID",
                    content: "Selezionate la casella se desiderate nascondere il nome della rete wireless (SSID) 2.4GHz dall'elenco delle reti Wi-Fi."
                }, {
                    type: "name",
                    title: "Password",
                    content: "Create una password wireless composta di 8-63 caratteri ASCII, o 8-64 caratteri esadecimali per rendere sicura la rete wireless."
                }, {
                    type: "name",
                    title: "Avanzate",
                    content: "Fate clic per vedere le impostazioni avanzate."
                }, {
                    type: "name",
                    title: "Sicurezza",
                    content: "Selezionate una delle seguenti opzioni di sicurezza:",
                    children: [
                        {
                            type: "name",
                            title: "Nessuna sicurezza",
                            content: "Selezionate l'opzione per disabilitare la sicurezza wireless. Vi <b> consigliamo </b> di abilitare la sicurezza wireless per proteggere la rete wireless da accessi non autorizzati."
                        }, {
                            type: "name",
                            title: "WPA/WPA2-Personal",
                            content: "Selezionate l'opzione per abilitare il metodo di autenticazione standard basato sull'utilizzo di una chiave precondivisa (PSK), detta anche passphrase. Opzione consigliata. Se selezionata, configurate quanto segue.",
                            children: [
                                {
                                    type: "name",
                                    title: "Versione",
                                    content: "Selezionate una versione di sicurezza per la rete wireless.",
                                    children: [
                                        {
                                            type: "name",
                                            title: "Auto",
                                            content: "L'opzione supporta implementazioni multiple del WPA (Wi-Fi Protected Access) standard, come WPA e WPA2."
                                        }, {
                                            type: "name",
                                            title: "WPA-PSK",
                                            content: "L'opzione supporta solo la crittografia TKIP che offre un buon livello di sicurezza."
                                        }, {
                                            type: "name",
                                            title: "WPA2-PSK",
                                            content: "L'opzione supporta la crittografia AES che garantisce un miglior livello di sicurezza rispetto a WPA-PSK ed è consigliata."
                                        }
                                    ]
                                }, {
                                    type: "name",
                                    title: "Crittografia",
                                    content: "Selezionate un tipo di crittografia di sicurezza: <b>TKIP</b> (Temporal Key Integrity Protocol),  <b>AES</b> (Advanced Encryption Standard), o <b>Automatica</b> (per TKIP e AES). Consigliamo di <b>NON</b> utilizzare la crittografia TKIP se il router funziona in modalità 802.11n, perché non è supportata dalle specifiche 802.11n. Se selezionate TKIP, la funzione WPS sarà disabilitata."
                                }
                            ]
                        }, {
                            type: "name",
                            title: "WEP",
                            content: "Selezionate l'opzione per abilitare il metodo di autenticazione di base se uno dei dispositivi client può accedere alla rete wireless solo utilizzando il protocollo WEP (Wired Equivalent Privacy).",
                            children: [
                                {
                                    type: "name",
                                    title: "Tipo",
                                    content: "Selezionate un tipo di autenticazione per la rete wireless. Il valore di default è <b>Auto</b>, che sceglie automaticamente tra <b>Open System</b> o <b>Shared Key</b> in base alla capacità e alla richiesta di accesso del client wireless."
                                }, {
                                    type: "name",
                                    title: "Chiave Selezionata",
                                    content: "Selezionate una delle 4 chiavi."
                                }, {
                                    type: "name",
                                    title: "Formato chiave WEP",
                                    content: "Utilizzate il formato ASCII o Esadecimale. Il formato ASCII è una combinazione di caratteri alfabetici e numerici. Il formato esadecimale è una combinazione di numeri (0-9) e lettere (A-F, a-f)."
                                }, {
                                    type: "name",
                                    title: "Tipo di chiave",
                                    content: "Selezionate la lunghezza della chiave WEP.",
                                    children: [
                                        {
                                            type: "name",
                                            title: "64 bit",
                                            content: "Permette di inserire 10 cifre esadecimali (0-9, A-F, a-f) o 5 caratteri ASCII nel campo password."
                                        }, {
                                            type: "name",
                                            title: "128 bit",
                                            content: "Permette di inserire 26 cifre esadecimali (0-9, A-F, a-f) o 13 caratteri ASCII nel campo password."
                                        }
                                    ]
                                }
                            ]
                        }
                    ]
                }, {
                    type: "name",
                    title: "Modalità",
                    content: "Selezionate una modalità di trasmissione mista."
                }, {
                    type: "name",
                    title: "Larghezza canale",
                    content: "Selezionate l'ampiezza di canale per la rete wireless 2.4GHz corrispondente."
                }, {
                    type: "name",
                    title: "Canale",
                    content: "Selezionate un canale operativo per la rete wireless 2.4GHz corrispondente. Se non si verificano problemi di instabilità wireless, vi consigliamo di lasciare l'impostazione del canale su <b>Auto</b>."
                }, {
                    type: "name",
                    title: "Potenza di trasmissione",
                    content: "Selezionate <b>Alta</b>, <b>Media</b>, o <b>Bassa</b> per specificare la potenza di trasmissione dati. L'impostazione predefinita e consigliata è <b>Alta</b>."
                }
            ]
        },
        WIRELESS_5G: {
            TITLE: "Wireless 5GHz",
            CONTENT: [
                {
                    type: "name",
                    title: "Abilita Wireless",
                    content: "Selezionate la casella di controllo per abilitare il wireless 5GHz."
                }, {
                    type: "name",
                    title: "Nome di rete wireless (SSID)",
                    content: "Potete lasciare il nome di default della rete (SSID), oppure immettere un nuovo nome (fino a 32 caratteri). Il campo fa distinzione tra maiuscole e minuscole."
                }, {
                    type: "name",
                    title: "Nascondi SSID",
                    content: "Selezionate la casella se desiderate nascondere il nome della rete wireless (SSID) 5GHz dall'elenco delle reti Wi-Fi."
                }, {
                    type: "name",
                    title: "Password",
                    content: "Create una password wireless composta di 8-63 caratteri ASCII, o 8-64 caratteri esadecimali per rendere sicura la rete wireless."
                }, {
                    type: "name",
                    title: "Avanzate",
                    content: "Fate clic per vedere più impostazioni avanzate."
                }, {
                    type: "name",
                    title: "Sicurezza",
                    content: "Selezionate una delle seguenti opzioni di sicurezza:",
                    children: [
                        {
                            type: "name",
                            title: "Nessuna sicurezza",
                            content: "Selezionate l'opzione per disabilitare la sicurezza wireless. Vi <b> consigliamo </b> di abilitare la sicurezza wireless per proteggere la rete wireless da accessi non autorizzati."
                        }, {
                            type: "name",
                            title: "WPA/WPA2-Personal",
                            content: "Selezionate l'opzione per abilitare il metodo di autenticazione standard basato sull'utilizzo di una chiave precondivisa (PSK), detta anche passphrase. Opzione consigliata. Se selezionata, configurate quanto segue.",
                            children: [
                                {
                                    type: "name",
                                    title: "Versione",
                                    content: "Selezionate una versione di sicurezza per la rete wireless.",
                                    children: [
                                        {
                                            type: "name",
                                            title: "Auto",
                                            content: "L'opzione supporta implementazioni multiple del WPA (Wi-Fi Protected Access) standard, come WPA e WPA2."
                                        }, {
                                            type: "name",
                                            title: "WPA-PSK",
                                            content: "L'opzione supporta solo la crittografia TKIP che offre un buon livello di sicurezza."
                                        }, {
                                            type: "name",
                                            title: "WPA2-PSK",
                                            content: "L'opzione supporta la crittografia AES che garantisce un miglior livello di sicurezza rispetto a WPA-PSK ed è consigliata."
                                        }
                                    ]
                                }, {
                                    type: "name",
                                    title: "Crittografia",
                                    content: "Selezionate un tipo di crittografia di sicurezza: <b>TKIP</b> (Temporal Key Integrity Protocol),  <b>AES</b> (Advanced Encryption Standard), o <b>Automatica</b> (per TKIP e AES). Consigliamo di <b>NON</b> utilizzare la crittografia TKIP se il router funziona in modalità 802.11n, perché non è supportata dalle specifiche 802.11n. Se selezionate TKIP, la funzione WPS sarà disabilitata."
                                }
                            ]
                        }, {
                            type: "name",
                            title: "WEP",
                            content: "Selezionate l'opzione per abilitare il metodo di autenticazione di base se uno dei dispositivi client può accedere alla rete wireless solo utilizzando il protocollo WEP (Wired Equivalent Privacy).",
                            children: [
                                {
                                    type: "name",
                                    title: "Tipo",
                                    content: "Selezionate un tipo di autenticazione per la rete wireless. Il valore di default è <b>Automatica</b>, che sceglie automaticamente tra <b>Open System</b> o <b>Shared Key</b> in base alla capacità e alla richiesta di accesso del client wireless."
                                }, {
                                    type: "name",
                                    title: "Chiave Selezionata",
                                    content: "Selezionate una delle 4 chiavi."
                                }, {
                                    type: "name",
                                    title: "Formato chiave WEP",
                                    content: "Utilizzate il formato ASCII o Esadecimale. Il formato ASCII è una combinazione di caratteri alfabetici e numerici. Il formato esadecimale è una combinazione di numeri (0-9) e lettere (A-F, a-f)."
                                }, {
                                    type: "name",
                                    title: "Tipo di chiave",
                                    content: "Selezionate la lunghezza della chiave WEP.",
                                    children: [
                                        {
                                            type: "name",
                                            title: "64 bit",
                                            content: "Permette di inserire 10 cifre esadecimali (0-9, A-F, a-f) o 5 caratteri ASCII nel campo password."
                                        }, {
                                            type: "name",
                                            title: "128 bit",
                                            content: "Permette di inserire 26 cifre esadecimali (0-9, A-F, a-f) o 13 caratteri ASCII nel campo password."
                                        }
                                    ]
                                }
                            ]
                        }
                    ]
                }, {
                    type: "name",
                    title: "Modalità",
                    content: "Selezionate una modalità di trasmissione mista."
                }, {
                    type: "name",
                    title: "Larghezza canale",
                    content: "Selezionate l'ampiezza di canale per la rete wireless 5GHz corrispondente."
                }, {
                    type: "name",
                    title: "Canale",
                    content: "Selezionate un canale operativo per la rete wireless 5GHz corrispondente. Se non si verificano problemi di instabilità wireless, vi consigliamo di lasciare l'impostazione del canale su <b>Auto</b>."
                }, {
                    type: "name",
                    title: "Potenza di trasmissione",
                    content: "Selezionate <b>Alta</b>, <b>Media</b>, o <b>Bassa</b> per specificare la potenza di trasmissione dati. L'impostazione predefinita e consigliata è <b>Alta</b>."
                }, {
                    type: "paragraph",
                    content: "Fate clic su Salva per salvare tutte le impostazioni."
                }
            ]
        },
        WIFI_TIME_CONTROL: {
            TITLE: "Schedulazione Wi-Fi",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "La Schedulazione Wi-Fi vi permette di impostare specifici periodi durante i quali il Wi-Fi sarà spento."
                }, {
                    type: "name",
                    title: "Schedulazione Wi-Fi",
                    content: "Spostate su <b>On</b> per abilitare la Schedulazione Wi-Fi. Se volete che il Wi-Fi rimanga acceso mentre i dispositivi wireless sono collegati alla rete wireless, selezionate la casella di controllo."
                }
            ]
        },
        WIFI_CLONE: {
            TITLE: "Wi-Fi Clone",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Wi-Fi Clone viene usato per copiare le impostazioni wireless (compresi SSID e password wireless) dalla rete wireless principale."
                }, {
                    type: "name",
                    title: "Selezione Frequenza Wi-Fi",
                    content: "Selezionate una <span class=\"anti_5g\">o entrambe</span> le reti da clonare. <span class=\"anti_5g\">Se la rete principale utilizza una sola frequenza per volta, vi consigliamo di selezionare 2.4GHz & 5GHz per essere sicuri che la frequenza clonata sia coerente con la frequenza della rete principale.</span>"
                }
            ]
        },
        WIFI_TIME_GRID: {
            TITLE: "Schedulazione Wi-Fi Spenta",
            CONTENT: [
                {
                    type: "name",
                    title: "Da",
                    content: "Mostra l'ora a partire dalla quale Wi-Fi si spegne."
                }, {
                    type: "name",
                    title: "A",
                    content: "Mostra l'ora a partire dalla quale Wi-Fi ritorna attivo."
                }, {
                    type: "name",
                    title: "Giorni",
                    content: "Mostra i giorni effettivi di schedulazione."
                }, {
                    type: "name",
                    title: "Stato",
                    content: "Indica lo stato corrente della schedulazione corrispondente. Fate clic sull'icona Lampadina per abilitare o disabilitare la schedulazione."
                }, {
                    type: "name",
                    title: "Modifica",
                    content: "Mostra le opzioni <b>Modifica</b> o <b>Elimina</b> per la schedulazione corrispondente."
                }, {
                    type: "step",
                    title: "Per creare una nuova schedulazione",
                    content: ["1. Fate clic su <b>Aggiungi</b>.", "2. Specificate un periodo di tempo durante il quale il Wi-Fi sarà spento.", "3.  Selezionate i giorni della settimana nei quali la schedulazione è attiva.", "4. Selezionate <b>Abilita questa riga</b>.", "5. Fate clic su <b>OK</b> per salvare la riga."]
                }, {
                    type: "paragraph",
                    content: "Per modificare o eliminare una riga Wi-Fi, fate clic sull'icona <b>Edita</b> per editare le informazioni o sull'icona <b>Cestino</b> per eliminare la riga corrispondente."
                }, {
                    type: "paragraph",
                    content: "Per eliminare più schedulazioni, selezionate le caselle di controllo delle schedulazioni che volete eliminare e fate clic su <b>Elimina</b> sopra la tabella."
                }
            ]
        },
        WPS: {
            TITLE: "PIN del Router",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Altri dispositivi possono connettersi a questo router tramite WPS con il PIN del router."
                }, {
                    type: "name",
                    title: "Abilita il PIN del router",
                    content: "Spostate su On per consentire la connessione dei dispositivi wireless al router tramite il PIN (Personal Identification Number) del router."
                }, {
                    type: "name",
                    title: "PIN del router",
                    content: "Mostra il PIN del router. Il PIN di default è riportato sull'etichetta del router o in questa Guida Utente. Fate clic su Genera per generare un nuovo codice PIN in modo casuale o fate clic su Default per ripristinare il PIN di default."
                }
            ]
        },
        WPS_WIZARD: {
            TITLE: "WPS Wizard",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Selezionate un'impostazione"
                }, {
                    type: "name",
                    title: "Pulsante (consigliata)",
                    content: "Selezionate questa impostazione per abilitare la funzionalità WPS, che permette di collegare facilmente qualsiasi dispositivo WPS alla rete wireless utilizzando il pulsante WPS o il pulsante Connetti."
                }, {
                    type: "name",
                    title: "PIN",
                    content: "Selezionate questa impostazione per aggiungere manualmente un dispositivo immettendo nel campo il PIN WPS del dispositivo wireless e facendo clic su Connetti."
                }
            ]
        },
        WIRELESS_STATISTICS: {
            TITLE: "Client Wireless Online",
            CONTENT: [
                {
                    type: "name",
                    title: "Client Totali",
                    content: "Mostra il numero totale di client wireless connessi alla rete powerline."
                }, {
                    type: "name",
                    title: "Nome Dispositivo",
                    content: "Mostra il nome del client wireless."
                }, {
                    type: "name",
                    title: "Indirizzo IP",
                    content: "Mostra l'indirizzo IP che sta usando il client wireless."
                }, {
                    type: "name",
                    title: "Indirizzo MAC",
                    content: "Mostra l'indirizzo MAC del client wireless."
                }, {
                    type: "name",
                    title: "Frequenza Wireless",
                    content: "Mostra la frequenza <span class=\"anti_5g\">(2.4GHz o 5GHz) </span>della rete wireless cui è connesso il client wireless."
                }, {
                    type: "name",
                    title: "Sicurezza",
                    content: "Mostra il tipo di sicurezza del client wireless."
                }, {
                    type: "paragraph",
                    content: "Fate clic su <b>Aggiorna</b> per aggiornare le informazioni di questa pagina."
                }
            ]
        },
        GUEST_NETWORK_BASIC: {
            TITLE: "Rete Ospiti",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "La <b>Rete Ospiti</b> vi consente di avere una rete wireless separata con nome di rete wireless (SSID) e password separati che gli ospiti possono utilizzare per accedere a Internet."
                }
            ]
        },
        GUEST_NETWORK_SETTINGS: {
            TITLE: "Rete Ospiti",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "La <b>Rete Ospiti</b> vi consente di avere una rete wireless separata con nome di rete wireless (SSID) e password separati che gli ospiti possono utilizzare per accedere a Internet."
                }, {
                    type: "name",
                    title: "Consenti agli ospiti di vedersi fra loro",
                    content: "Selezionate questa casella di controllo per consentire ai dispositivi wireless della rete ospiti di vedersi fra loro."
                }, {
                    type: "name",
                    title: "Vieta agli ospiti di gestire la mia rete",
                    content: "Selezionate questa opzione per evitare che gli ospiti possano accedere all'interaccia di gestione web."
                }, {
                    type: "name",
                    title: "Disabilitazione automatica dopo",
                    content: "Selezionate questa opzione per spegnere automaticamente la Rete Ospiti in base ad una specifica schedulazione."
                }, {
                    type: "paragraph",
                    content: "Fate clic su <b>Salva</b> per salvare tutte le impostazioni."
                }
            ]
        },
        GUEST_NETWORK_WIRELESS: {
            TITLE: "Impostazioni Rete Ospiti",
            CONTENT: [
                {
                    type: "name",
                    title: "2.4GHz | 5GHz",
                    content: "Selezionate 2.4GHz o 5GHz per vedere le relative impostazioni."
                }, {
                    type: "name",
                    title: "Abilita Rete Ospiti",
                    content: "Selezionate la casella di controllo per abilitare la Rete Ospiti."
                }, {
                    type: "name",
                    title: "Nome di rete wireless (SSID)",
                    content: "Usate il nome Rete Ospiti (SSID) di default o create un nuovo nome (fino a 32 caratteri)."
                }, {
                    type: "name",
                    title: "Sicurezza",
                    content: "Selezionate una delle seguenti opzioni di sicurezza:",
                    children: [
                        {
                            type: "name",
                            title: "Nessuna sicurezza",
                            content: "Selezionate questa opzione per disabilitare la sicurezza wireless. Vi <u><b> consigliamo vivamente </b></u> di attivare la sicurezza wireless per proteggere la Rete Ospiti da accessi non autorizzati."
                        }, {
                            type: "name",
                            title: "WPA/WPA2 - Personal",
                            content: "Selezionate questa opzione per abilitare il metodo di autenticazione standard basato sull'utilizzo di una Pre-shared Key (PSK), detta anche passphrase. Se selezionata, configurate quanto segue."
                        }
                    ]
                }, {
                    type: "name",
                    title: "Password",
                    content: "Utilizzate la password di default o createne una composta da 8-63 caratteri ASCII o 8-64 caratteri esadecimali (0-9, a-f, A-F)."
                }, {
                    type: "paragraph",
                    content: "Fate clic su <b>Salva</b> per salvare le impostazioni wireless della Rete Ospiti."
                }
            ]
        },
        GUEST_NETWORK_WIRELESS_2G: {
            TITLE: "Impostazioni Wireless",
            CONTENT: [
                {
                    type: "name",
                    title: "Abilita Rete Ospiti",
                    content: "Selezionate la casella di controllo per abilitare la Rete Ospiti."
                }, {
                    type: "name",
                    title: "Nome di rete wireless (SSID)",
                    content: "Usate il nome Rete Ospiti (SSID) di default o create un nuovo nome (fino a 32 caratteri)."
                }, {
                    type: "name",
                    title: "Sicurezza",
                    content: "Selezionate una delle seguenti opzioni di sicurezza:",
                    children: [
                        {
                            type: "name",
                            title: "Nessuna sicurezza",
                            content: "Selezionate questa opzione per disabilitare la sicurezza wireless. Vi <u><b> consigliamo vivamente <u><b> di attivare la sicurezza wireless per proteggere la Rete Ospiti da accessi non autorizzati."
                        }, {
                            type: "name",
                            title: "WPA/WPA2 - Personal",
                            content: "Selezionate questa opzione per abilitare il metodo di autenticazione standard basato sull'utilizzo di una chiave precondivisa (PSK), detta anche passphrase. Se selezionata, configurate quanto segue."
                        }
                    ]
                }, {
                    type: "name",
                    title: "Password",
                    content: "Utilizzate la password di default o createne una composta da 8-63 caratteri ASCII o 8-64 caratteri esadecimali (0-9, a-f, A-F)."
                }, {
                    type: "paragraph",
                    content: "Fate clic su <b>Salva</b> per salvare le impostazioni wireless della Rete Ospiti."
                }
            ]
        },
        NAT: {
            TITLE: "Application Layer Gateway(ALG)",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "ALG consente di collegare al gateway i filtri trasversali NAT (Network Address Translation) personalizzati per supportare la traduzione dell'indirizzo e della porta per alcuni protocolli di livello applicazione \"control/data\": FTP, TFTP, H323 ecc. Si consiglia l'abilitazione ALG."
                }, {
                    type: "name",
                    title: "Abilita ALG FTP",
                    content: "Se selezionata, permette ai client e ai server FTP (File Transfer Protocol) di trasferire i dati via NAT."
                }, {
                    type: "name",
                    title: "Abilita ALG TFTP",
                    content: "Se selezionata, permette ai client e ai server TFTP (Trivial File Transfer Protocol) di trasferire i dati via NAT."
                }, {
                    type: "name",
                    title: "Abilita ALG H323",
                    content: "Se selezionata, permette ai client Microsoft NetMeeting di comunicare via NAT."
                }, {
                    type: "name",
                    title: "Abilita ALG RTSP",
                    content: "Se selezionata, permette ai lettori multimediali client di comunicare con i server di flussi multimediali via NAT."
                }, {
                    type: "name",
                    title: "Abilita passthrough PPTP",
                    content: "Se selezionata, permette il tunneling delle sessioni Point-to-Point attraverso una rete IP e il passaggio attraverso il router."
                }, {
                    type: "name",
                    title: "Abilita passthrough L2TP",
                    content: "Se selezionata, permette il tunneling delle sessioni Point-to-Point Layer 2 attraverso una rete IP e il passaggio attraverso il router."
                }, {
                    type: "name",
                    title: "Abilita passthrough IPSec",
                    content: "Se selezionata, permette il tunneling dei criteri IPSec (Internet Protocol security) attraverso una rete IP e il passaggio attraverso il router. IPSec utilizza i servizi crittografici di sicurezza per garantire comunicazioni private e sicure sulle reti IP."
                }, {
                    type: "paragraph",
                    content: "Fate clic su Salva per salvare tutte le impostazioni."
                }
            ]
        },
        VIRTUAL_SERVERS: {
            TITLE: "Virtual Servers",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "I Server Virtuali vengono utilizzati per impostare i servizi pubblici sulla rete locale. Un server virtuale è definito come una porta esterna, e tutte le richieste da Internet a questa porta esterna saranno reindirizzate a un computer designato, configurato con un indirizzo IP statico o riservato."
                }, {
                    type: "name",
                    title: "Tipo di servizio",
                    content: "Mostra il nome del server virtuale."
                }, {
                    type: "name",
                    title: "Porta esterna",
                    content: "Mostra il numero di porta o un intervallo di porte utilizzate dal server virtuale."
                }, {
                    type: "name",
                    title: "IP interno",
                    content: "Mostra l'indirizzo IP del computer che esegue l'applicazione di servizio."
                }, {
                    type: "name",
                    title: "Porta interna",
                    content: "Mostra il numero di porta del computer che esegue l'applicazione di servizio."
                }, {
                    type: "name",
                    title: "Protocollo",
                    content: "Mostra il protocollo utilizzato per l'applicazione di servizio: TCP, UDP o All (tutti i protocolli supportati dal router)."
                }, {
                    type: "name",
                    title: "Stato",
                    content: "Mostra lo stato corrente (abilitato o disabilitato) della regola di filtro specifica. "
                }, {
                    type: "name",
                    title: "Modifica",
                    content: "Mostra le opzioni per modificare o eliminare la regola corrispondente."
                }, {
                    type: "step",
                    title: "Per impostare una regola server virtuale",
                    content: ["1. Fate clic su Aggiungi.", "2. Fate clic su Mostra Servizi Esistenti per selezionare un servizio dall'elenco per popolare automaticamente il numero di porta appropriato nei campi Porta esterna e Porta interna. Se il servizio non è presente nell'elenco, immettete il numero della porta esterna (ad es.  21) o un intervallo di porte (ad es. 21-25). Lasciate vuoto il campo Porta interna se è uguale a Porta esterna, oppure immettete un numero di porta specifico (ad es. 21) se la porta esterna è una sola. Inserite l'indirizzo IP del computer che esegue l'applicazione di servizio in formato decimale puntato nel campo IP interno.", "3. Selezionate un protocollo per l'applicazione di servizio: TCP, UDP o All dall'elenco a discesa dei Protocolli.", "4. Selezionate Abilita.", "5. Fate clic su OK."]
                }, {
                    type: "step",
                    title: "Per modificare o eliminare una regola di server virtuale",
                    content: "Nella tabella, fate clic sull'icona Modifica o Cestino in corrispondenza alla regola che desiderate modificare o eliminare."
                }, {
                    type: "step",
                    title: "Per eliminare più regole",
                    content: "Selezionate tutte le righe che desiderate eliminare e fate clic su Elimina sopra la tabella."
                }, {
                    type: "note",
                    title: "Nota",
                    content: "Se il dispositivo host locale ospita più di un tipo di servizio disponibile, è necessario creare una regola per ogni servizio."
                }
            ]
        },
        PORT_TRIGGERING: {
            TITLE: "Port Triggering",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Port Triggering è utilizzato per inoltrare il traffico su una determinata porta a un server specifico della rete."
                }, {
                    type: "name",
                    title: "Applicazione",
                    content: "Mostra il nome dell'applicazione."
                }, {
                    type: "name",
                    title: "Porta Triggering",
                    content: "Mostra la porta del traffico in uscita utilizzata per attivare una regola di filtro di una connessione in uscita."
                }, {
                    type: "name",
                    title: "Protocollo Trigger",
                    content: "Mostra il protocollo utilizzato per attivare porte. TCP, UDP o All (tutti i protocolli supportati dal router)."
                }, {
                    type: "name",
                    title: "Porta Esterna",
                    content: "Mostra la porta o l'intervallo di porte utilizzate dal sistema remoto. Tramite una di queste porte sarà inoltrata una risposta al PC che attiva la regola. Potete immettere al massimo 5 gruppi di porte (o sezioni di porte). Ogni gruppo di porte deve essere separato da \",\" (virgola), ad esempio, 2000-2038, 2046, 2050-2051, 2085, 3010-3030."
                }, {
                    type: "name",
                    title: "Protocollo Esterno",
                    content: "Mostra il protocollo utilizzato per la porta in ingresso: TCP, UDP o All (tutti i protocolli supportati dal router)."
                }, {
                    type: "name",
                    title: "Stato",
                    content: "Mostra lo stato corrente (abilitato o disabilitato) della regola di filtro specifica."
                }, {
                    type: "name",
                    title: "Modifica",
                    content: "Mostra le opzioni per modificare o eliminare la regola corrispondente."
                }, {
                    type: "step",
                    title: "Per impostare una regola Porta Triggering",
                    content: [
                        {
                            type: "note",
                            title: "Nota",
                            content: "Ogni regola può essere utilizzata da un solo host per volta."
                        },
                        "1. Fate clic su Aggiungi.", {
                            content: "2. Fate clic su Mostra Applicazioni Esistenti per selezionare un'applicazione dall'elenco e popolare automaticamente i campi con i valori predefiniti appropriati. Se desiderate aggiungere un'applicazione non inclusa nell'elenco, immettete manualmente Applicazione, Porta Triggering, Protocollo Triggering, Porta Esterna e Protocollo Esterno.",
                            children: [
                                {
                                    type: "note",
                                    title: "Nota",
                                    content: "Le regole non  possono avere range di porte sovrapposte fra loro; se, ad esempio, la Regola 1 ha un range di porte 4200-4205, la Regola 2 non può avere un range di porte 4203-4206)."
                                }
                            ]
                        },
                        "3. Selezionate Abilita.",
                        "4. Fate clic su OK."
                    ]
                }, {
                    type: "step",
                    title: "Per modificare o eliminare una regola Porta Triggering",
                    content: "Nella tabella, fate clic sull'icona Modifica o Cestino in corrispondenza della regola che desiderate modificare o eliminare."
                }, {
                    type: "step",
                    title: "Per eliminare più regole Porta Triggering",
                    content: "Nella tabella, selezionate tutte le regole che desiderate eliminare, quindi fate clic su Elimina, sopra la tabella."
                }
            ]
        },
        DMZ: {
            TITLE: "DMZ",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "La funzione DMZ (Demilitarized Zone) consente a un host locale di essere accessibile via Internet per un servizio con un fine particolare, ad esempio giochi online o videoconferenze. In genere la DMZ consente a un singolo computer della LAN di aprire tutte le porte. Il computer deve essere configurato con un indirizzo IP statico e avere la funzione client DHCP disabilitata."
                }, {
                    type: "step",
                    title: "Per assegnare a un computer o un server la funzione di server DMZ",
                    content: ["1. Fate clic su DMZ.", "2. Nel campo Indirizzo IP Host DMZ, immettete l'indirizzo IP del computer locale che desiderate configurare come host DMZ.", "3. Fate clic su Salva."]
                }
            ]
        },
        UPNP: {
            TITLE: "UPnP",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Di default la funzione UPnP (Universal Plug-and-Play) è abilitata e consente a tutti i dispositivi, quali computer e applicazioni Internet, di essere rilevati automaticamente e comunicare tra loro sulla rete locale."
                }, {
                    type: "paragraph",
                    content: "L'elenco dei servizi UPnP mostra le informazioni sul dispositivo UPnP."
                }, {
                    type: "name",
                    title: "Descrizione del servizio",
                    content: "Mostra una breve descrizione dell'host locale che avvia la richiesta UPnP."
                }, {
                    type: "name",
                    title: "Porta esterna",
                    content: "Mostra la porta esterna aperta dall'host locale."
                }, {
                    type: "name",
                    title: "Protocollo",
                    content: "Mostra il tipo di protocollo di rete utilizzato dall'host locale."
                }, {
                    type: "name",
                    title: "Indirizzo IP interno",
                    content: "Mostra l'indirizzo IP dell'host locale."
                }, {
                    type: "name",
                    title: "Porta interna",
                    content: "Mostra la porta interna aperta dall'host locale. "
                }, {
                    type: "paragraph",
                    content: "Fate clic su Aggiorna per aggiornare l'elenco dei server UPnP."
                }
            ]
        },
        DISK_SETTING: {
            TITLE: "Impostazioni Dispositivo",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "La pagina Impostazioni Dispositivo visualizza le informazioni di ogni dispositivo di storage USB collegato tramite la porta USB."
                }, {
                    type: "name",
                    title: "Scansiona",
                    content: "Solitamente il router rileva automaticamente qualsiasi dispositivo appena collegato. Se ciò non avviene, fate clic su questo pulsante per fare la scansione di ogni nuovo dispositivo connesso e aggiornare la pagina con le informazioni aggiornate."
                }, {
                    type: "name",
                    title: "Volume",
                    content: "Mostra il nome del volume USB."
                }, {
                    type: "name",
                    title: "Capacità",
                    content: "Mostra la capacità di storage totale del dispositivo USB. "
                }, {
                    type: "name",
                    title: "Spazio libero",
                    content: "Mostra lo spazio di storage corrente disponibile. "
                }, {
                    type: "name",
                    title: "Rimozione sicura",
                    content: "Fate clic su questo pulsante per disconnettere in modo sicuro il dispositivo di storage USB prima di scollegarlo fisicamente dal router."
                }, {
                    type: "paragraph",
                    content: "Il pulsante Rimozione Sicura appare solo quando vi è un dispositivo di storage USB collegato al router. Non sarà possibile smontare il dispositivo USB mentre il volume corrente è occupato."
                }, {
                    type: "name",
                    title: "Attivo",
                    content: "Questa casella di controllo appare solo quando vi è un dispositivo di storage USB collegato al router. Selezionate per abilitare la condivisione dei file del dispositivo USB."
                }, {
                    type: "step",
                    title: "Per impostare un file server",
                    content: ["1. Collegate il dispositivo storage USB alla porta USB del router tramite un cavo USB.", "2. Il nuovo dispositivo USB dovrebbe essere rilevato automaticamente dal router e le relative informazioni visualizzate nella sezione Impostazioni Dispositivo. In caso contrario, fate clic su Scansiona.", "3. Selezionate Attiva per attivare la condivisione di file."]
                }
            ]
        },
        FOLDER_SHARE_ACCOUNT: {
            TITLE: "Account di Condivisione",
            CONTENT: [
                {
                    type: "name",
                    title: "Account",
                    content: "È possibile selezionare Utilizza Account di Default per accedere ai file e alle cartelle condivise o Utilizza Nuovo Account e immettere le seguenti informazioni per creare un nuovo account utente."
                }, {
                    type: "name",
                    title: "Username/Password",
                    content: "Immettete una stringa alfanumerica composta da un massimo di 15 caratteri. Il nome utente deve iniziare con una lettera dell'alfabeto. Questi campi fanno distinzione tra maiuscole e minuscole."
                }, {
                    type: "name",
                    title: "Conferma password",
                    content: "Immettete nuovamente la password per confermare che non ci siano errori di battitura. Questo campo fa distinzione tra maiuscole e minuscole."
                }, {
                    type: "paragraph",
                    content: "Fate clic su Salva per salvare tutte le impostazioni."
                }
            ]
        },
        FOLDER_SHARE_SETTINGS: {
            TITLE: "Impostazioni Condivisione",
            CONTENT: [
                {
                    type: "name",
                    title: "Rete/Nome server multimediale",
                    content: "Mostra il nome utilizzato per accedere al dispositivo di storage USB collegato."
                }, {
                    type: "name",
                    title: "Abilita",
                    content: "Selezionate per abilitare il metodo di accesso."
                }, {
                    type: "name",
                    title: "Metodo di Accesso",
                    content: "Esistono tre metodi di accesso al dispositivo di storage USB collegato. È possibile scegliere uno o più metodi di accesso selezionando la casella di controllo corrispondente.",
                    children: [
                        {
                            type: "name",
                            title: "Risorse di rete",
                            content: "Se abilitato, gli utenti della rete possono accedere al dispositivo di storage USB utilizzando un indirizzo IP assegnato (ad es. \\\\192.168.0.1)."
                        }, {
                            type: "name",
                            title: "FTP",
                            content: "Se abilitato, i client FTP sulla rete locale possono accedere al dispositivo di storage USB utilizzando l'indirizzo IP assegnato, seguito dal numero di porta del server FTP (ad es. ftp://192.168.0.1:21)."
                        }, {
                            type: "name",
                            title: "FTP (via Internet)",
                            content: "Se abilitato, gli utenti possono accedere da remoto all'unità di storage USB tramite FTP via Internet. La funzione supporta download e upload dei file. Per cambiare il numero di porta del server FTP, immettete un numero di porta e fate clic su Salva per applicare le modifiche."
                        }
                    ]
                }, {
                    type: "name",
                    title: "Collegamento",
                    content: "Mostra l'indirizzo utilizzato per accedere al dispositivo storage USB condiviso."
                }, {
                    type: "name",
                    title: "Porta",
                    content: "Mostra il numero di porta del server FTP."
                }
            ]
        },
        FOLDER_SHARE_FOLDERS: {
            TITLE: "Cartella Condivisione",
            CONTENT: [
                {
                    type: "name",
                    title: "Condividi tutte",
                    content: "Attivate per condividere tutti i file e le cartelle o disattivate per condividere solo le cartelle selezionate."
                }, {
                    type: "name",
                    title: "Abilita autenticazione",
                    content: "Vi consigliamo di abilitare l'autenticazione per richiedere agli utenti di inserire nome utente e password validi per accedere alle cartelle condivise."
                }, {
                    type: "name",
                    title: "Nome cartella",
                    content: "Mostra il nome della cartella condivisa."
                }, {
                    type: "name",
                    title: "Percorso cartella",
                    content: "Mostra il percorso della cartella condivisa."
                }, {
                    type: "name",
                    title: "Condivisione file multimediali",
                    content: "Indica se la cartella condivisa può essere utilizzata o meno per condividere file multimediali."
                }, {
                    type: "name",
                    title: "Nome volume",
                    content: "Mostra il nome del volume condiviso."
                }, {
                    type: "name",
                    title: "Stato",
                    content: "Mostra lo stato della cartella condivisa per mezzo dall'indicatore a lampadina. Verde (ON) è abilitato e Grigio (OFF) è disabilitato. Potete abilitare o disabilitare la condivisione facendo clic sulla lampadina."
                }, {
                    type: "name",
                    title: "Modifica",
                    content: "Mostra le opzioni per modificare o eliminare la cartella condivisa corrispondente."
                }, {
                    type: "name",
                    title: "Sfoglia",
                    content: "Fate clic per cercare una cartella condivisa."
                }, {
                    type: "name",
                    title: "Consenti accesso a Rete Ospiti",
                    content: "Selezionate per consentire ai client della Rete Ospiti di accedere alle cartelle condivise."
                }, {
                    type: "name",
                    title: "Abilita autenticazione",
                    content: "Selezionate per richiedere agli utenti di accedere alle cartelle condivise con nome utente e password."
                }, {
                    type: "name",
                    title: "Attiva accesso in scrittura",
                    content: "Selezionate per consentire agli utenti di apportare modifiche al contenuto della cartella."
                }, {
                    type: "name",
                    title: "Attiva condivisione file multimediali",
                    content: "Selezionate per abilitare la condivisione multimediale."
                }
            ]
        },
        PRINT_SERVER: {
            TITLE: "Print Server",
            CONTENT: [
                {
                    type: "step",
                    title: "Per configurare un Print Server da utilizzare nella vostra rete",
                    content: ["1. Collegate una stampante USB alla porta USB del router tramite un cavo USB.", "2. Installate i driver della stampante nel vostro computer. Consultate il manuale del produttore del computer per avere istruzioni.", "3. Installate la TP-LINK USB Printer Controller Utility (per Windows e Mac OS X), scaricandola dal sito ufficiale di TP-LINK."]
                }
            ]
        },
        PARENTAL_CONTROL: {
            TITLE: "Parental Control",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Con il Parental Control potete bloccare siti Web inappropriati e limitare l'accesso a Internet in determinate ore del giorno."
                }, {
                    type: "name",
                    title: "Parental Controls",
                    content: "Spostate su <b>Acceso</b> per abilitare il Parental Control."
                }
            ]
        },
        PARENTAL_CONTROL_DEVICES: {
            TITLE: "Dispositivi Sotto Parental Control",
            CONTENT: [
                {
                    type: "name",
                    title: "ID",
                    content: "Mostra lo ID del dispositivo client."
                }, {
                    type: "name",
                    title: "Indirizzo MAC",
                    content: "Mostra l'indirizzo MAC del dispositivo client. "
                }, {
                    type: "name",
                    title: "Tempo d'accesso a Internet",
                    content: "Mostra i periodi di tempo con accesso consentito."
                }, {
                    type: "name",
                    title: "Descrizione",
                    content: "Mostra una breve descrizione del dispositivo connesso."
                }, {
                    type: "name",
                    title: "Stato",
                    content: "Mostra lo stato corrente (abilitato o disabilitato) del Parental Control del dispositivo corrispondente. "
                }, {
                    type: "name",
                    title: "Modifica",
                    content: "Mostra le opzioni per modificare o eliminare il dispositivo corrispondente."
                }, {
                    type: "step",
                    title: "Per limitare un nuovo dispositivo client",
                    content: [
                        "1. Fate clic su  <b>Aggiungi</b>.",
                        "2. Fate clic su <b>Mostra Dispositivi Esistenti</b> e scegliete un dispositivo collegato dall'elenco <b>Dispositivo Accesso Wirelesse</b>; oppure immettete manualmente lo <b>Indirizzo MAC</b> per aggiungere un dispositivo che non è collegato.",
                        "3. Fate clic sull'icona <b>Tempo di Accesso a Internet</b> per specificare un periodo di tempo durante il quale il dispositivo potrà accedere a Internet.",
                        "4. Immettete una breve descrizione nel campo <b>Descrizione</b>. Questo campo è facoltativo.",
                        "5. Selezionate <b>Abilita Questa Riga</b>..",
                        "6. Fate clic su <b>OK</b> per salvare questa riga."
                    ]
                }, {
                    type: "paragraph",
                    content: "Per modificare o eliminare una riga dalla lista, fate clic su <b>Modifica</b> per modificare le informazioni o su <b>Cestino</b> per rimuovere la riga corrispondente."
                }, {
                    type: "paragraph",
                    content: "Per eliminare più dispositivi dalla lista, selezionate la casella di controllo corrispondente ai dispositivi da eliminare e fate clic su <b>Elimina</b> sotto la tabella."
                }
            ]
        },
        PARENTAL_CONTROL_RESTRICTION: {
            TITLE: "Restrizione Contenuti",
            CONTENT: [
                {
                    type: "name",
                    title: "Blacklist",
                    content: "Contiene le parole chiave che saranno utilizzate per bloccare l'accesso a qualsiasi sito Web da parte dei dispositivi client specificati nell'elenco Parental Control.",
                    children: [
                        {
                            type: "paragraph",
                            content: "Fate clic su Aggiungi Nuova Parola Chiave per aggiungere una parola chiave alla blacklist. Per eliminare una parola chiave, fate clic sul segno meno (-) a fianco della parola chiave che desiderate eliminare."
                        }
                    ]
                }, {
                    type: "name",
                    title: "Whitelist",
                    content: "Contiene gli indirizzi dei siti Web a cui i dispositivi client specificati nell'elenco Parental Control possono accedere.",
                    children: [
                        {
                            type: "paragraph",
                            content: "Fate clic su Aggiungi Nuovo Nome di Dominio per aggiungere un sito Web alla whitelist. Per eliminare un sito Web, fate clic sul segno meno (-) a fianco del sito Web che desiderate eliminare."
                        }
                    ]
                }, {
                    type: "note",
                    title: "Nota",
                    content: "Le parole chiave possono essere anche i nomi di dominio, ad esempio, www.mail.google.com o www.facebook.com."
                }, {
                    type: "paragraph",
                    content: "Fate clic su Salva per salvare la configurazione."
                }
            ]
        },
        QOS: {
            TITLE: "QoS",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Il Quality of Service (QoS) aiuta a definire la priorità del traffico Internet in base alle proprie esigenze. Nell'elenco delle regole QoS potete specificare il livello di priorità di un dispositivo o di un'applicazione."
                }, {
                    type: "note",
                    title: "Nota",
                    content: "Se NAT Boost è abilitato, QoS dovrebbe essere disabilitato."
                }, {
                    type: "name",
                    title: "Abilita QoS",
                    content: "Selezionate questa casella per abilitare il QoS."
                }, {
                    type: "name",
                    title: "Banda Upload",
                    content: "Inserite la banda massima di upload fornita dal proprio ISP (Internet Service Provider)."
                }, {
                    type: "name",
                    title: "Banda Download",
                    content: "Immettete la banda massima di download fornita dal vostro ISP."
                }, {
                    type: "name",
                    title: "Priorità alta",
                    content: "Specificate una percentuale per il traffico con priorità alta."
                }, {
                    type: "name",
                    title: "Priorità media",
                    content: "Specificate una percentuale per il traffico con priorità media."
                }, {
                    type: "name",
                    title: "Priorità bassa",
                    content: "Specificate una percentuale per il traffico con priorità bassa."
                }, {
                    type: "note",
                    title: "Nota",
                    content: "La somma (percentuale) di tutte le priorità dovrebbe essere 1."
                }, {
                    type: "paragraph",
                    content: "Fate clic su Salva per salvare tutte le impostazioni."
                }
            ]
        },
        QOS_RULE: {
            TITLE: "Lista Regole QoS",
            CONTENT: [
                {
                    type: "name",
                    title: "Tipo",
                    content: "Selezionate un tipo da aggiungere all'elenco delle regole QoS."
                }, {
                    type: "step",
                    title: "Per impostare una regola per la priorità alta/media/bassa Per Dispositivo",
                    content: ["1. Fate clic su Aggiungi.", "2. Selezionate Per Dispositivo.", "3. Fate clic su Mostra Dispositivi Esistenti per selezionare il dispositivo desiderato dalla Lista Dispositivi di Accesso, oppure immettete il nome del dispositivo e il suo indirizzo MAC manualmente nei campi Nome Dispositivo e Indirizzo MAC.", "4. Fate clic su OK."]
                }, {
                    type: "step",
                    title: "Per impostare una regola per la priorità alta/media/bassa Per Applicazione",
                    content: ["1. Fate clic su Aggiungi.", "2. Selezionate Per Applicazione.", "3. Selezionate l'applicazione desiderata dall'elenco Applicazioni, oppure personalizzate un'applicazione configurandone nome, protocollo e porta di destinazione nei campi corrispondenti.", "4. Fate clic su OK."]
                }, {
                    type: "step",
                    title: "Per impostare una regola per la priorità alta/media/bassa Per Porta Fisica",
                    content: ["1. Fate clic su Aggiungi.", "2. Selezionate Per Porta Fisica.", "3. Selezionate la porta desiderata.", "4. Fate clic su OK."]
                }
            ]
        },
        QOS_DATABASE: {
            TITLE: "Aggiornamento Database",
            CONTENT: [
                {
                    type: "name",
                    title: "Nuovo File Database",
                    content: "Fate clic su Sfoglia per individuare il nuovo database. Selezionate e fate clic su Aggiorna per aggiornare il database ad una versione più recente."
                }, {
                    type: "name",
                    title: "Versione Database",
                    content: "Mostra la versione di database corrente."
                }
            ]
        },
        SECURITY_FIREWALL: {
            TITLE: "Firewall",
            CONTENT: [
                {
                    type: "name",
                    title: "Firewall SPI",
                    content: "Il firewall SPI (Stateful Packet Inspection) previene gli attacchi informatici e convalida il traffico passante dal router in base al protocollo. Il Firewall SPI è abilitato di default. "
                }
            ]
        },
        SECURITY_DOS: {
            TITLE: "Protezione DoS",
            CONTENT: [
                {
                    type: "name",
                    title: "Protezione DoS",
                    content: "La protezione DoS (Denial of Service) protegge la LAN dagli attacchi DoS, impedendo il blocco del server causato da un numero eccessivo di richieste. Di default, la Protezione DoS è disabilitata (Off)."
                }, {
                    type: "name",
                    title: "Filtro attacco ICMP-FLOOD",
                    content: "Attivate per prevenire attacchi flood ICMP (Internet Control Message Protocol)."
                }, {
                    type: "name",
                    title: "Filtro attacco UDP-FLOOD",
                    content: "Attivate per prevenire attacchi UDP (User Datagram Protocol)."
                }, {
                    type: "name",
                    title: "Filtro attacco TCP-SYN-FLOOD",
                    content: "Attivate per prevenire attacchi flood ICMP (Internet Control Message Protocol).",
                    children: [
                        {
                            type: "name",
                            title: "Spento",
                            content: "Nessuna protezione."
                        }, {
                            type: "name",
                            title: "Bassa",
                            content: "Livello basso di protezione e impatto basso sulle prestazioni del router."
                        }, {
                            type: "name",
                            title: "Media",
                            content: "Livello moderato di protezione e impatto moderato sulle prestazioni del router."
                        }, {
                            type: "name",
                            title: "Alta",
                            content: "Livello alto di protezione e impatto notevole sulle prestazioni del router."
                        }
                    ]
                }, {
                    type: "name",
                    title: "Ignora pacchetti ping da porta WAN",
                    content: "Attivate per ignorare i pacchetti ping provenienti dalla porta WAN."
                }, {
                    type: "name",
                    title: "Vieta pacchetti ping da porta LAN",
                    content: "Attivate per vietare i pacchetti ping provenienti dalla porta LAN."
                }
            ]
        },
        MAC_FILTER_ALL: {
            TITLE: "Filtro MAC",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Filtro MAC viene usato per permettere o vietare l'accesso alla vostra rete a specifici computer e altri dispositivi. Quando un dispositivo è bloccato, non può connettersi al dispositivo powerline."
                }, {
                    type: "name",
                    title: "Impostazioni Filtro MAC",
                    children: [
                        {
                            type: "name",
                            title: "Filtro MAC",
                            content: "Spostate su <b>On</b> per abilitare questa funzione. Se la funzione è disabilitata (Off), si potranno collegare tutti i dispositivi."
                        }
                    ]
                }, {
                    type: "name",
                    title: "Selezionate le regola di filtro",
                    content: "Selezionate se bloccare o autorizzare l'accesso alla rete wireless ai dispositivi client presenti nell'Elenco Dispositivi. Fate clic su <b>Salva</b> per salvare le vostre impostazioni."
                }, {
                    type: "name",
                    title: "Elenco Dispositivi",
                    children: [
                        {
                            type: "step",
                            title: "Per aggiungere un dispositivo client"
                        }, {
                            type: "step",
                            title: "Per modificare o eliminare un dispositivo client",
                            content: "Fate clic su <b>Modifica</b> o su <b>Cestino</b> in corrispondenza al dispositivo che volete modificare o eliminare."
                        }, {
                            type: "step",
                            title: "Per eliminare più dispositivi dall'Elenco Dispositivi",
                            content: "Selezionate la casella di controllo in corrispondenza ai dispostivi che volete eliminare, poi fate clic su <b>Elimina</b> sopra la tabella."
                        }
                    ]
                }
            ]
        },
        MAC_FILTER: {
            TITLE: "Filtro MAC",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Filtro MAC viene usato per bloccare o autorizzare l'accesso alla vostra rete a computer specifici o altri dispositivi. Quando un dispositivo è bloccato non si può connettere al dispositivo powerline."
                }, {
                    type: "name",
                    title: "Impostazioni Filtro MAC",
                    children: [
                        {
                            type: "name",
                            title: "Filtro MAC",
                            content: "Spostate su <b>On</b> per abilitare questa funzione. Se la funzione è disabilitata (Off), si potranno collegare tutti i dispositivi."
                        }
                    ]
                }
            ]
        },
        MAC_FILTER_RULES: {
            TITLE: "Selezionate le regola di filtro",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Selezionate se bloccare o autorizzare l'accesso alla rete wireless ai dispositivi client presenti nell'Elenco Dispositivi."
                }, {
                    type: "paragraph",
                    content: "Fate clic su  <b>Salva</b> per salvare tutte le impostazioni."
                }
            ]
        },
        MAC_FILTER_DEVICE_LIST: {
            TITLE: "Elenco Dispositivi",
            CONTENT: [
                {
                    type: "step",
                    title: "Per aggiungere un dispositivo client",
                    content: ["1. Fate clic su <b>Aggiungi</b>.", "2. Fate clic su <b>Visualizza Dispositivi</b> e scegliete l'indirizzo MAC di un dispositivo dell'elenco, o immettete manualmente l'indirizzo MAC. ", "3. Immettete una descrizione del  dispositivo.", "4. Selezionate <b>Abilita questa riga.</b>", "5. Fate clic su <b>OK</b>."]
                }, {
                    type: "step",
                    title: "Per modificare o eliminare un dispositivo dell'Elenco Dispositivi",
                    content: "Fate clic su <b>Modifica</b> o su <b>Cestino</b> in corrispondenza del dispositivo che volete modificare o eliminare."
                }, {
                    type: "step",
                    title: "Per eliminare più dispositivi dall'Elenco Dispositivi",
                    content: "Selezionate la casella di controllo in corrispondenza dei dispostivi che volete eliminare, poi fate clic su <b>Elimina</b> sopra la tabella."
                }
            ]
        },
        WIFI_MOVE: {
            TITLE: "Wi-Fi Move",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Con Wi-Fi Move abilitato, tutte le modifiche apportate alle impostazioni Wi-Fi di un dispositivo powerline verranno automaticamente estese agli altri dispositivi powerline presenti nella stessa rete powerline che hanno la funzione Wi-Fi Move abilitata. Fate attenzione che se il nome di default, es. HomePlugAV, è già utilizzata, il Wi-Fi Move verrà automaticamente disabilitato."
                }, {
                    type: "name",
                    title: "Wi-Fi Move",
                    content: "Spostate su <b>On</b> per abilitare questa funzione."
                }
            ]
        },
        SECURITY_LIST: {
            TITLE: "Lista Host DoS Bloccati",
            CONTENT: [
                {
                    type: "name",
                    title: "Elenco Host DoS Bloccati",
                    content: "Elenca gli Indirizzi IP e MAC di qualsiasi fonte di attacco DoS bloccato."
                }, {
                    type: "step",
                    title: "Per eliminare una riga",
                    content: "Nell'elenco Host, selezionate la voce che desiderate eliminare e fate clic su Elimina, sopra la tabella."
                }
            ]
        },
        ACCESS_CONTROL: {
            TITLE: "Controllo Accessi",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Controllo Accessi viene utilizzato per consentire o bloccare l'accesso in rete a computer o dispositivi specifici. Quando un dispositivo è bloccato può  ottenere un indirizzo IP dal router, ma non può comunicare con altri dispositivi o connettersi a Internet."
                }, {
                    type: "paragraph",
                    content: "Per utilizzare il Controllo Accessi, abilitate la funzione e specificate una blacklist o una whitelist. Se il Controllo Accessi è disabilitato (Off), tutti i dispositivi, compresi quelli sulla blacklist, possono connettersi."
                }
            ]
        },
        ACCESS_MODE: {
            TITLE: "Modalità Accesso",
            CONTENT: [
                {
                    type: "name",
                    title: "Blacklist",
                    content: "L'accesso alla rete verrà negato solo ai dispositivi in Blacklist."
                }, {
                    type: "name",
                    title: "Whitelist",
                    content: "L'accesso alla rete verrà garantito solo ai dispositivi in Whitelist."
                }
            ]
        },
        ACCESS_DEVICE: {
            TITLE: "Dispositivi Online",
            CONTENT: [
                {
                    type: "name",
                    title: "Nome Dispositivo",
                    content: "Visualizza il nome del dispositivo connesso."
                }, {
                    type: "name",
                    title: "Indirizzo IP",
                    content: "Visualizza l'indirizzo IP del dispositivo connesso."
                }, {
                    type: "name",
                    title: "Indirizzo MAC",
                    content: "Visualizza l'indirizzo MAC del dispositivo connesso."
                }, {
                    type: "name",
                    title: "Tipo Connessione",
                    content: "Visualizza il tipo di connessione del dispositivo connesso."
                }, {
                    type: "step",
                    title: "Per bloccare un dispositivo",
                    content: "Nella tabella Dispositivi Online, nella colonna Modifica, fate clic su Blocca in corrispondenza del dispositivo che desiderate bloccare."
                }, {
                    type: "step",
                    title: "Per bloccare più dispositivi",
                    content: "Nella tabella Dispositivi Online, selezionate tutti i dispositivi che desiderate bloccare, quindi fate clic su Blocca sopra la tabella.  Il dispositivo verrà aggiunto automaticamente all'elenco dei dispositivi in Blacklist o Whitelist."
                }
            ]
        },
        ACCESS_LIST: {
            TITLE: "Dispositivi in BlackList/WhiteList",
            CONTENT: [
                {
                    type: "step",
                    title: "Per aggiungere un dispositivo alla blacklist o alla whitelist",
                    content: ["1. Fate clic su Aggiungi.", "2. Immettete il Nome Dispositivo.", "3. Immettete l'indirizzo MAC del dispositivo.", "4. Fate clic su OK."]
                }, {
                    type: "step",
                    title: "Per modificare o eliminare un dispositivo nella BlackList/Whitelist",
                    content: "Nella tabella BlackList/Whitelist, fate clic su Modifica o su Elimina in corrispondenza del dispositivo che desiderate modificare o eliminare."
                }, {
                    type: "step",
                    title: "Per eliminare più dispositivi nella BlackList/Whitelist",
                    content: "Nella tabella BlackList/Whitelist, selezionate tutti i dispositivi che desiderate eliminare, quindi fate clic su Elimina, sopra la lista."
                }
            ]
        },
        IPMAC_BIND_SETTING: {
            TITLE: "Impostazioni",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "La funzione ARP (Address Resolution Protocol) binding permette di controllare l'accesso di un computer specifico della LAN associando l'indirizzo IP e l'indirizzo MAC del dispositivo. ARP binding impedisce inoltre ad altri dispositivi di utilizzare un indirizzo IP specifico."
                }
            ]
        },
        IPMAC_BIND_ARP: {
            TITLE: "Lista ARP",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Mostra gli indirizzi MAC e IP dei dispositivi attualmente connessi."
                }, {
                    type: "name",
                    title: "Numero Righe ARP",
                    content: "Mostra il numero totale di dispositivi attualmente connessi al router."
                }, {
                    type: "name",
                    title: "Indirizzo MAC",
                    content: "Mostra l'indirizzo MAC del dispositivo connesso."
                }, {
                    type: "name",
                    title: "Indirizzo IP",
                    content: "Mostra l'indirizzo IP assegnato al dispositivo connesso."
                }, {
                    type: "name",
                    title: "Associato",
                    content: "Indica se gli indirizzi MAC e IP sono associati o meno."
                }, {
                    type: "name",
                    title: "Modifica",
                    content: "Mostra le opzioni per associare o eliminare la voce corrispondente nell'elenco."
                }, {
                    type: "note",
                    title: "Nota",
                    content: "Non è possibile associare lo stesso indirizzo IP a più indirizzi MAC."
                }
            ]
        },
        IPMAC_BIND_LIST: {
            TITLE: "Lista Binding",
            CONTENT: [
                {
                    type: "step",
                    title: "Per impostare un dispositivo con ARP binding",
                    content: [
                        "1. Fate clic su Aggiungi.",
                        "2. Immettete l'indirizzo MAC del dispositivo.",
                        "3. Immettete un indirizzo IP che desiderate associare all'indirizzo MAC di cui sopra.",
                        "4. Immettete una descrizione del dispositivo (facoltativa).",
                        "5. Selezionate Abilita.",
                        "6. Fate clic su OK."
                    ]
                }, {
                    type: "step",
                    title: "Per modificare o eliminare una riga",
                    content: "Nell'elenco Associazioni, fate clic su Modifica o su Elimina in corrispondenza del dispositivo che desiderate modificare o eliminare."
                }, {
                    type: "step",
                    title: "Per eliminare più righe",
                    content: "Nell'elenco Associazioni, selezionate tutti i dispositivi che desiderate eliminare, quindi fate clic su Elimina, sopra la lista."
                }
            ]
        },
        IPV6: {
            TITLE: "Internet",
            CONTENT: [
                {
                    type: "name",
                    title: "IPv6",
                    content: "Selezionate per abilitare (On) o disabilitare (Off) la funzione IPv6 del router."
                }, {
                    type: "title",
                    title: "Tipo di connessione Internet: IP Statico"
                }, {
                    type: "name",
                    title: "IP Statico",
                    content: "Selezionate questo tipo se l'ISP utilizza l'assegnazione di un indirizzo statico IPv6."
                }, {
                    type: "name",
                    title: "Indirizzo IPv6/Gateway predefinito/DNS Primario/DNS Secondario",
                    content: "Immettete i parametri forniti dall'ISP."
                }, {
                    type: "name",
                    title: "Dimensione MTU",
                    content: "La dimensione predefinita tipica dell'unità massima di trasmissione (MTU) della maggior parte delle reti Ethernet è 1.500 byte. Consigliamo di NON cambiare la dimensione MTU predefinita se non richiesto dall'ISP."
                }, {
                    type: "title",
                    title: "Tipo di connessione Internet: IP Dinamico"
                }, {
                    type: "name",
                    title: "IP Dinamico",
                    content: "Selezionate questo tipo se l'ISP utilizza l'assegnazione dinamica dell'indirizzo IPv6."
                }, {
                    type: "name",
                    title: "Indirizzo IPv6/DNS Primario/DNS Secondario",
                    content: "Questi parametri vengono assegnati automaticamente dal server DHCPv6 dell'ISP."
                }, {
                    type: "name",
                    title: "Rinnova",
                    content: "Fate clic sul pulsante per ottenere nuovi parametri IPv6 dal server DHCPv6 dell'ISP."
                }, {
                    type: "name",
                    title: "Rilascia",
                    content: "Fate clic sul pulsante per rilasciare tutti gli indirizzi IPv6 assegnati dal server DHCPv6 dell'ISP."
                }, {
                    type: "name",
                    title: "Ottieni Indirizzo IPv6",
                    content: "Selezionate per ottenere un indirizzo IPv6 non temporaneo o una delega di prefisso IPv6, in base all'ISP."
                }, {
                    type: "name",
                    title: "Indirizzo DNS",
                    content: "Selezionate per ottenere in modo dinamico l'indirizzo dall'ISP oppure utilizzate il seguente indirizzo DNS. Se è selezionato “Usa il seguente Indirizzo DNS”, immettete manualmente l'indirizzo DNS fornito dall'ISP."
                }, {
                    type: "name",
                    title: "DNS Primario/DNS Secondario",
                    content: "Immettete i parametri manualmente oppure otteneteli dinamicamente dall'ISP."
                }, {
                    type: "title",
                    title: "Tipo di Connessione Internet: PPPoE"
                }, {
                    type: "name",
                    title: "PPPoE",
                    content: "Selezionate questo tipo se l'ISP utilizza PPPoEv6 e fornisce un nome utente e una password."
                }, {
                    type: "name",
                    title: "Username/Password",
                    content: "Immettete i parametri forniti dall'ISP."
                }, {
                    type: "name",
                    title: "Indirizzo IPv6",
                    content: "L'indirizzo verrà assegnato automaticamente dal server DHCPv6 dell'ISP, dopo che avrete inserito il nome utente e la password e fatto clic su Connetti."
                }, {
                    type: "name",
                    title: "Indirizzo DNS",
                    content: "Selezionate per ottenere in modo dinamico l'indirizzo dall'ISP oppure utilizzate il seguente indirizzo DNS. Se è selezionato “Usa il seguente Indirizzo DNS”, immettete manualmente l'indirizzo DNS fornito dall'ISP."
                }, {
                    type: "name",
                    title: "Ottieni Indirizzo IPv6",
                    content: "Selezionate \"Non temporaneo\", \"Delega prefisso\" o \"Specificato dall'ISP\" in base all'ISP. Se selezionate \"Specificato dall'ISP\", immettete manualmente l'indirizzo IPv6 fornito dall'ISP. Se selezionate \"Non temporaneo\" o \"Delega prefisso\", l'indirizzo IPv6 verrà assegnato automaticamente dal server DHCPv6 dell'ISP.",
                    children: [
                        {
                            type: "name",
                            title: "Non temporaneo",
                            content: "Ottenete un indirizzo IPv6 non temporaneo dal server DHCPv6 dell'ISP."
                        }, {
                            type: "name",
                            title: "Delega prefisso",
                            content: "Ottenete un indirizzo IPv6 con delega prefisso dal server DHCPv6 dell'ISP, e il client nella LAN creerà un indirizzo IPv6 con la delega."
                        }, {
                            type: "name",
                            title: "Specificato dall'ISP",
                            content: "Usate un indirizzo IPv6 statico specificato dall'ISP."
                        }
                    ]
                }, {
                    type: "name",
                    title: "Connetti",
                    content: "Fate clic sul pulsante per connettervi a Internet."
                }, {
                    type: "name",
                    title: "Disconnetti",
                    content: "Fate clic sul pulsante per disconnettervi da  Internet."
                }, {
                    type: "title",
                    title: "Tipo Connessione Internet: Tunnel 6to4"
                }, {
                    type: "name",
                    title: "Tunnel 6to4",
                    content: "Selezionate questo tipo se l'ISP utilizza la distribuzione 6to4 per assegnare gli indirizzi."
                }, {
                    type: "name",
                    title: "Indirizzo IPv4/Subnet Mask IPv4/Gateway IPv4 di Default/Indirizzo Tunnel",
                    content: "Questi parametri saranno generati dinamicamente dalle informazioni IPv4 della porta WAN dopo che avrete fatto clic su Connetti."
                }, {
                    type: "name",
                    title: "Utilizza il seguente Server DNS",
                    content: "Selezionate la casella di controllo per inserire manualmente DNS primario/ DNS secondario forniti dall'ISP."
                }, {
                    type: "name",
                    title: "Connetti",
                    content: "Fate clic sul pulsante per connettervi a Internet."
                }, {
                    type: "name",
                    title: "Disconnetti",
                    content: "Fate clic sul pulsante per disconnettervi da Internet."
                }, {
                    type: "title",
                    title: "Tipo di connessione Internet: 6RD"
                }, {
                    type: "name",
                    title: "6RD",
                    content: "Selezionate questo tipo se l'ISP utilizza la distribuzione 6RD e fornisce un indirizzo IPv4 e prefissi di indirizzi IPv6."
                }, {
                    type: "name",
                    title: "Tipo di Configurazione",
                    content: "Selezionate Automatica o Manuale per configurare i parametri dei canali 6RD in conformità all'ISP. Se i parametri di default indicati di seguito coincidono con quelli forniti dall'ISP, è possibile selezionare Automatica; in caso contrario, selezionate Manuale e immettete i parametri forniti dall'ISP."
                }, {
                    type: "name",
                    title: "Lunghezza Maschera IPv4/Prefisso 6RD/Lunghezza prefisso 6RD/Indirizzo IPv4 Border Reply",
                    content: "Controllate se i parametri preimpostati coincidono con quelli forniti dall'ISP. Potete mantenere le impostazioni predefinite o immettere manualmente i parametri forniti dall'ISP."
                }, {
                    type: "title",
                    title: "Tipo Connessione Internet: DS-Lite"
                }, {
                    type: "name",
                    title: "DS-Lite",
                    content: "Selezionate questo tipo se l'ISP utilizza la distribuzione DS-Lite e fornisce un nome di dominio AFTR o un indirizzo IPv6 per la creazione di un tunnel IPv4-in-IPv6 nella rete IPv6 per comunicare il traffico IPv4 o IPv6 alle rispettive reti."
                }, {
                    type: "name",
                    title: "Nome AFTR",
                    content: "AFTR è l'abbreviazione di Address Family Transition Router. In questo campo, immettete il nome di dominio AFTR o l'indirizzo IPv6 fornito dall'ISP."
                }, {
                    type: "name",
                    title: "Connessione Secondaria",
                    content: "Selezionate il tipo di connessione secondaria fornito dall'ISP.",
                    children: [
                        {
                            type: "name",
                            title: "IP Dinamico",
                            content: "Selezionate se l'ISP fornisce l'IP dinamico come tipo di connessione secondaria, nel qual caso i parametri Indirizzo IPv6/DNS Primario/ DNS Secondario verranno assegnati automaticamente dal server DHCPv6 dell'ISP."
                        }, {
                            type: "name",
                            title: "IP Statico",
                            content: "Selezionate se l'ISP assegna Indirizzi IPv6 Statici."
                        }, {
                            type: "name",
                            title: "PPPoE",
                            content: "Selezionate se l'ISP fornisce PPPoE come tipo di connessione secondaria e inserite username/password forniti dall'ISP. L'indirizzo IPv6 verrà assegnato automaticamente dopo che avrete fatto clic su Connetti."
                        }
                    ]
                }, {
                    type: "title",
                    title: "Tipo Connessione Internet: Pass-Through (Bridge)"
                }, {
                    type: "paragraph",
                    content: "Selezionate questo tipo se l'ISP utilizza la  distribuzione di rete Pass Through (Bridge). Per questo tipo di connessione non è richiesta alcuna configurazione."
                }
            ]
        },
        IPV6_LAN: {
            TITLE: "LAN",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Tranne Pass-Through (bridge), gli altri 6 tipi di connessione Internet richiedono allo stesso tempo la configurazione dei parametri IPv4 LAN."
                }, {
                    type: "name",
                    title: "Tipo assegnato",
                    content: "Selezionate quello appropriato in base all'ISP.",
                    children: [
                        {
                            type: "name",
                            title: "DHCPv6",
                            content: "Per assegnare automaticamente gli indirizzi IP ai client della LAN.",
                            children: [
                                {
                                    type: "name",
                                    title: "Prefisso Indirizzo",
                                    content: "Immettete il prefisso indirizzo fornito dall'ISP."
                                }, {
                                    type: "name",
                                    title: "Durata Rilascio",
                                    content: "La durata di validità dell'indirizzo IP assegnato espressa in secondi. Mantenete l'impostazione di default di 86.400 secondi o modificatela se richiesto dall'ISP."
                                }, {
                                    type: "name",
                                    title: "Indirizzo",
                                    content: "È l'indirizzo IP assegnato automaticamente dal server DHCPv6 dell'ISP."
                                }
                            ]
                        }, {
                            type: "name",
                            connector: " ",
                            title: "SLAAC + Stateless DHCP",
                            children: [
                                {
                                    type: "name",
                                    title: "Prefisso Indirizzo",
                                    content: "Immettete il prefisso indirizzo fornito dall'ISP."
                                }, {
                                    type: "name",
                                    title: "Indirizzo",
                                    content: "È l'indirizzo IP assegnato automaticamente dal server DHCPv6 dell'ISP."
                                }
                            ]
                        }, {
                            type: "name",
                            connector: " ",
                            title: "SLAAC+RDNSS",
                            children: [
                                {
                                    type: "name",
                                    title: "Prefisso Indirizzo",
                                    content: "Immettete il prefisso indirizzo fornito dall'ISP."
                                }, {
                                    type: "name",
                                    title: "Indirizzo",
                                    content: "È l'indirizzo IP assegnato automaticamente dal server DHCPv6 dell'ISP."
                                }
                            ]
                        }
                    ]
                }
            ]
        },
        IPV6_MAC_CLONE: {
            TITLE: "MAC Clone",
            CONTENT: [
                {
                    type: "name",
                    title: "Utilizza Indirizzo MAC di Default",
                    content: "NON modificate l'indirizzo MAC di default del router, per evitare l'insorgere di problemi nel caso in cui l'ISP vincoli l'indirizzo IP assegnato all'indirizzo MAC."
                }, {
                    type: "name",
                    title: "Utilizza Indirizzo MAC computer corrente",
                    content: "Selezionate per copiare l'indirizzo MAC corrente del computer connesso al router, nel caso in cui l'ISP vincoli l'indirizzo IP assegnato all'indirizzo MAC del computer."
                }, {
                    type: "name",
                    title: "Utilizza Indirizzo MAC personalizzato",
                    content: "Immettete l'indirizzo MAC manualmente, nel caso in cui l'ISP vincoli l'indirizzo IP assegnato a un indirizzo MAC specifico."
                }
            ]
        },
        TIME_SETTING: {
            TITLE: "Impostazioni Orario",
            CONTENT: [
                {
                    type: "step",
                    title: "Per sincronizzare automaticamente l'ora",
                    content: ["1. Selezionate il <b>Fuso Orario</b> locale dal menu a discesa.", "2. Nel campo <b>Server NTP I</b>, immettete l'indirizzo IP o il nome del dominio del server NTP desiderato. (facoltativo)", "3. Nel campo <b>Server NTP II</b>, immettete l'indirizzo IP o il nome del dominio del server NTP desiderato. (facoltativo)", "4. Fate clic su <b>Ottieni GMT</b>."]
                }, {
                    type: "step",
                    title: "Per impostare manualmente data e ora",
                    content: ["1. Nel campo <b>Impostazioni Ora</b>, selezionate il vostro <b>Fuso Orario</b> locale.", "2. Immettete la <b>Data</b> corrente.", "3. Selezionate la <b>Ora</b> corrente (nel formato a 24 ore, ad es. 16.00.00 equivale a 04:00 PM).", "4. Fate clic su <b>Salva</b>."]
                }
            ]
        },
        TIME_SETTING_DAYLIGHT: {
            TITLE: "Ora Legale",
            CONTENT: [
                {
                    type: "step",
                    title: "Per impostare l'ora legale",
                    content: ["1. Selezionate <b>Attiva Ora Legale</b>.", "2. Selezionate la data e l'ora in cui avrà inizio l'ora legale nel vostro fuso orario.", "3. Selezionate la data e l'ora in cui avrà termine l'ora legale nel vostro fuso orario.", "4. Fate clic su <b>Salva</b>."]
                }
            ]
        },
        DIGNOSTIC: {
            TITLE: "Diagnostica",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Il router fornisce i tool Ping e Traceroute che consentono di risolvere i problemi di connettività di rete. Il tool Ping invia i pacchetti a un indirizzo IP o un nome di dominio di destinazione e registra i risultati, come ad esempio il numero di pacchetti inviati e ricevuti e il tempo di andata e ritorno. Il tool Traceroute invia i pacchetti a un indirizzo IP o un nome di dominio di destinazione e visualizza il numero di hop e il tempo impiegati per raggiungere la destinazione."
                }, {
                    type: "paragraph",
                    content: "Potete utilizzare Ping e Traceroute con un dispositivo locale tramite l'indirizzo IP o un nome di dominio, come google.com, yahoo.com, ecc."
                }, {
                    type: "step",
                    title: "Per eseguire una diagnosi con Ping",
                    content: ["1. Immettete l'indirizzo IP o il Nome di Dominio di destinazione.", "2. Fate clic sull'icona Freccia per aprire il menu Avanzate e specificate il conteggio dei ping e la dimensione del pacchetto ping. (facoltativo)", "3. Fate clic su Avvio."]
                }, {
                    type: "step",
                    title: "Per eseguire una diagnosi con Traceroute",
                    content: ["1. Immettete l'indirizzo IP o il nome di dominio di destinazione.", "2. Fate clic sull'icona Freccia per aprire il menu Avanzate e specificare il numero di hop nel campo Traceroute Max TTL (Time to Live). Di default è 20. (facoltativo)", "3. Fate clic su Avvio."]
                }
            ]
        },
        FIRMWARE: {
            TITLE: "Aggiornamento Firmware",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Prima di aggiornare il firmware del powerline scaricate nel vostro computer l'ultimo aggiornamento firmware dal sito web <a class=\"link\" href=\"http://www.tp-link.com/it/support/\" target=\"_blank\">TP-LINK Support</a>."
                }, {
                    type: "step",
                    title: "IMPORTANTE: Per evitare che fallisca l'aggiornamento, procedete come segue:",
                    content: ["Assicuratevi che il firmware più recente corrisponda alla versione hardware (come mostrato alla pagina Aggiornamento Firmware).", "Assicuratevi di utilizzare una connessione stabile tra il powerline e il computer. Consigliamo di NON aggiornare il firmware in modalità wireless.", "Eseguite il backup della configurazione del powerline.", "NON spegnete il powerline durante l'aggiornamento firmware."]
                }, {
                    type: "step",
                    title: "Per aggiornare il firmware del powerline",
                    content: ["1. Fate clic su <b>Sfoglia</b>.", "2. Selezionate il firmware scaricato.", "3. Fate clic su <b>Aggiorna</b>."]
                }, {
                    type: "paragraph",
                    content: "Il processo di aggiornamento richiede alcuni minuti prima di essere completato. NON spegnete il powerline durante l'aggiornamento."
                }
            ]
        },
        FIRMWARE_UPGRADE_ONLINE: {
            TITLE: "Per aggiornare il firmware online",
            CONTENT: [
                {
                    type: "paragraph",
                    content: ["Fate clic su Aggiorna e confermate quando appare il messaggio di avviso. Il del dispositivo powerline scaricherà e aggiornerà automaticamente l'ultimo firmware. Potete anche fare clic su Controlla per verificare l'ultima versione di firmware."]
                }
            ]
        },
        FIRMWARE_UPGRADE: {
            TITLE: "Per aggiornare il firmware manualmente",
            CONTENT: [
                {
                    type: "step",
                    content: ["1. Fate clic su Supporto in fondo alla pagina e scaricate il firmware più recente nel computer. Assicuratevi che il firmware che avete scaricato abbia la stessa versione hardware del router come mostrato in questa pagina.", "2. Fate clic su Sfoglia e selezionate il firmware scaricato.", "3. Fate clic su Aggiorna."]
                }, {
                    type: "paragraph",
                    content: ["L'aggiornamento firmware richiede qualche minuto per completarsi. Il del dispositivo powerline si riavvia automaticamente quando è finito l'aggiornamento firmware."]
                }
            ]
        },
        BACKUP: {
            TITLE: "Backup",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Vi consigliamo di eseguire il backup delle configurazioni correnti, nel caso in cui fosse necessario ripristinare il sistema a uno stato precedente o alle impostazioni di fabbrica."
                }, {
                    type: "paragraph",
                    content: "Fate clic su <b>Backup</b> per salvare le configurazioni correnti sul computer. Assicuratevi di salvare il file di backup in un luogo sicuro, che vi permetta di ripristinare facilmente il powerline in seguito, se necessario."
                }
            ]
        },
        RESTORE: {
            TITLE: "Ripristino",
            CONTENT: [
                {
                    type: "step",
                    title: "Per ripristinare da un backup",
                    content: ["1. Fate clic su <b>Sfoglia</b>.", "2. Selezionate il file di backup.", "3. Fate clic su <b>Ripristina</b>."]
                }
            ]
        },
        FACTORY: {
            TITLE: "Ripristino Impostazioni di Fabbrica di Default",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Fate clic su <b>Ripristino Impostazioni di Fabbrica di Default<b> per ripristinare le impostazioni di fabbrica del powerline."
                }, {
                    type: "note",
                    title: "Nota",
                    content: ["1. Riporta a Impostazioni di Fabbrica eliminerà tutte le impostazioni che avete configurato nel dispositivo powerline. Per rifare login alla pagina di gestione del dispositivo powerline, usate <b>admin</b> come username e password.", "2. NON spegnete il dispositivo powerline durante il processo di backup o ripristino."]
                }
            ]
        },
        ADMIN_ACCOUNT: {
            TITLE: "Gestione Account",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Questa pagina vi permette di modificare il nome utente e/o la password."
                }, {
                    type: "name",
                    title: "Vecchio Nome Utente",
                    content: "Immettete il nome utente corrente."
                }, {
                    type: "name",
                    title: "Vecchia Password",
                    content: "Immettete la password corrente."
                }, {
                    type: "name",
                    title: "Nuovo Nome Utente",
                    content: "Immettete il nuovo nome utente."
                }, {
                    type: "name",
                    title: "Nuova Password",
                    content: "Immettete la nuova password."
                }, {
                    type: "name",
                    title: "Conferma Nuova Password",
                    content: "Immettete nuovamente la password."
                }, {
                    type: "note",
                    title: "Nota",
                    content: "Se decidete di cambiare il nome utente e la password correnti utilizzati per accedere al powerline, assicuratevi di scrivere le nuove informazioni di accesso in un luogo sicuro. Una password robusta deve contenere almeno 8 caratteri, combinando maiuscole e minuscole, numeri e punteggiatura."
                }, {
                    type: "paragraph",
                    content: "Fate clic su Salva per salvare tutte le impostazioni."
                }
            ]
        },
        ADMIN_RECOVERY: {
            TITLE: "Recupero Password",
            CONTENT: [
                {
                    type: "name",
                    title: "Abilita Recupero password",
                    content: "Vi consigliamo vivamente di attivare la funzionalità Recupero Password, che vi invierà il nome utente e la password persi o dimenticati via email."
                }, {
                    type: "name",
                    title: "Da",
                    content: "Immettete un indirizzo email valido da utilizzare per la posta in uscita."
                }, {
                    type: "name",
                    title: "A",
                    content: "Immettete un indirizzo email valido da utilizzare per la posta in arrivo."
                }, {
                    type: "name",
                    title: "Server SMTP",
                    content: "Immettete l'indirizzo del server SMTP che il router utilizza per inviare le informazioni relative all'account via email."
                }, {
                    type: "name",
                    title: "Abilita autenticazione",
                    content: "Selezionate Abilita Autenticazione se il server di posta in uscita richiede l'autenticazione per l'invio di email, e immettete il nome utente e la password nei campi corrispondenti. I campi fanno distinzione tra maiuscole e minuscole."
                }
            ]
        },
        ADMIN_LOCAL: {
            TITLE: "Gestione Locale",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Questa sezione permette di limitare il numero di dispositivi client della LAN cui è consentito accedere al router utilizzando l'autenticazione basata sull'indirizzo MAC."
                }, {
                    type: "name",
                    title: "Accesso a tutti i dispositivi connessi alla LAN",
                    content: "Attivate per abilitare la gestione locale di tutti i dispositivi connessi alla LAN o disattivate per abilitare la gestione di un dispositivo specifico."
                }, {
                    type: "name",
                    title: "Indirizzo MAC",
                    content: "Mostra l'indirizzo MAC del dispositivo con accesso limitato."
                }, {
                    type: "name",
                    title: "Descrizione",
                    content: "Mostra la descrizione del dispositivo con accesso limitato."
                }, {
                    type: "name",
                    title: "Stato",
                    content: "Mostra lo stato corrente del dispositivo con accesso limitato (abilitato o disabilitato)."
                }, {
                    type: "name",
                    title: "Modifica",
                    content: "Mostra le opzioni per modificare o eliminare il dispositivo corrispondente dell'elenco."
                }, {
                    type: "step",
                    title: "Per aggiungere un dispositivo client all'elenco",
                    content: ["1. Fate clic su Aggiungi.", "2. Fate clic su Mostra Dispositivi Esistenti e scegliete un dispositivo esistente o immettete l'indirizzo MAC di un dispositivo nel campo Indirizzo MAC. ", "3. Immettete una descrizione del dispositivo.", "4. Selezionate Abilita.", "5. Fate clic su OK."]
                }, {
                    type: "step",
                    title: "Per modificare o eliminare un dispositivo dell'elenco",
                    content: "Nella tabella, fate clic su Modifica o su Elimina per modificare o eliminare il dispositivo corrispondente. "
                }, {
                    type: "step",
                    title: "Per eliminare più dispositivi",
                    content: "Selezionate tutti i dispositivi che desiderate eliminare, quindi fate clic su Elimina."
                }
            ]
        },
        ADMIN_REMOTE: {
            TITLE: "Gestione Remota",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "La funzione Gestione Remota consente di accedere e configurare il router in remoto tramite Internet."
                }, {
                    type: "name",
                    title: "Disabilita Gestione Remota",
                    content: "Selezionate l'opzione per disabilitare la gestione remota."
                }, {
                    type: "name",
                    title: "Abilita Gestione Remota per tutti i dispositivi",
                    content: "Selezionate l'opzione per abilitare la gestione remota di tutti gli indirizzi IP. Se selezionata, compilate il campo Porta Gestione Web."
                }, {
                    type: "name",
                    title: "Abilita gestione remota per i dispositivi specificati",
                    content: "Selezionate l'opzione per abilitare la gestione remota di un indirizzo IP specifico. Se selezionata, compilate i campi Porta Gestione Web e Indirizzo IP Gestione Remota."
                }, {
                    type: "name",
                    title: "Porta di Gestione Web",
                    content: "Immettete il numero di porta compreso tra 1024 e 65535 che viene utilizzato per accedere all'interfaccia di gestione Web del router con maggiore sicurezza. Normalmente, i browser web utilizzano la porta di servizio HTTP standard 80. La porta di servizio comune predefinita è 8080, che è una porta di servizio alternativa di HTTP."
                }, {
                    type: "name",
                    title: "Indirizzo IP Gestione Remota",
                    content: "Immettete un indirizzo IP o un range di indirizzi IP valido per poter accedere al router. Se viene immesso 255.255.255.255 può accedere chiunque."
                }
            ]
        },
        SYSTEM_LOG: {
            TITLE: "Log di Sistema",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "La pagina Log di Sistema visualizza un elenco delle attività (eventi) più recenti del powerline. Potete definire i tipi di registri e/o il livello di registri che desiderate visualizzare."
                }, {
                    type: "name",
                    title: "Tipo",
                    content: "Selezionate il tipo di log di sistema da visualizzare."
                }, {
                    type: "name",
                    title: "Livello",
                    content: "Selezionate il livello di log di sistema da visualizzare."
                }, {
                    type: "name",
                    title: "Aggiorna",
                    content: "Fate clic sull'icona per aggiornare i log di sistema."
                }, {
                    type: "name",
                    title: "Elimina tutto",
                    content: "Fate clic sull'icona per eliminare tutti i log di sistema."
                }, {
                    type: "name",
                    title: "Salva log",
                    content: "Fate clic sul pulsante per scaricare tutti i log di sistema sul computer locale."
                }
            ]
        },
        TRAFFIC_STATISTIC: {
            TITLE: "Statistiche Traffico ",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "La pagina Statistiche di Traffico mostra il traffico di rete LAN, WAN e WLAN di pacchetti inviati e ricevuti."
                }, {
                    type: "note",
                    title: "Nota",
                    content: "Se è abilitato NAT Boost, le Statistiche di Traffico saranno disabilitate."
                }, {
                    type: "name",
                    title: "Statistiche di Traffico",
                    content: "Di default Statistiche di Traffico è Spento. Per mostrare le informazioni delle statistiche, fate clic su Acceso."
                }
            ]
        },
        TRAFFIC_STATISTIC_LIST: {
            TITLE: "Elenco Statistiche Traffico ",
            CONTENT: [
                {
                    type: "name",
                    title: "Indirizzo IP/Indirizzo MAC",
                    content: "Mostra l'indirizzo IP e l'indirizzo MAC del dispositivo client associato."
                }, {
                    type: "name",
                    title: "Totale Pacchetti",
                    content: "Mostra il numero totale di pacchetti trasmessi e ricevuti dal dispositivo client dall'inizio della sessione o dall'ultimo reset del contatore."
                }, {
                    type: "name",
                    title: "Totale Byte",
                    content: "Mostra il numero totale di byte trasmessi e ricevuti dal dispositivo client dall'inizio della sessione o dall'ultimo reset del contatore."
                }, {
                    type: "name",
                    title: "Pacchetti Correnti",
                    content: "Mostra il numero corrente di pacchetti trasmessi e ricevuti in un intervallo di tempo specifico."
                }, {
                    type: "name",
                    title: "Byte Correnti",
                    content: "Mostra il numero corrente di byte trasmessi e ricevuti in un intervallo di tempo specifico."
                }, {
                    type: "name",
                    title: "ICMP Tx Correnti",
                    content: "Mostra il livello delle trasmissioni correnti e il livello massimo di trasmissione dei pacchetti ICMP trasmessi attraverso la porta WAN per secondo."
                }, {
                    type: "name",
                    title: "UDP Tx Correnti",
                    content: "Mostra il livello delle trasmissioni correnti e il livello massimo di trasmissione dei pacchetti UDP trasmessi attraverso la porta WAN per secondo."
                }, {
                    type: "name",
                    title: "SYN Tx Correnti",
                    content: "Mostra il livello delle trasmissioni correnti e il livello massimo di trasmissione dei pacchetti TCP SYN trasmessi attraverso la porta WAN per secondo."
                }, {
                    type: "name",
                    title: "Modifica",
                    content: "Mostra le opzioni per azzerare o eliminare le statistiche corrispondenti dall'elenco."
                }, {
                    type: "name",
                    title: "Aggiorna",
                    content: "Fate clic per aggiornare le informazioni statistiche sulla pagina."
                }, {
                    type: "name",
                    title: "Ripristina tutto",
                    content: "Fate clic per azzerare tutti i valori statistici dell'elenco."
                }, {
                    type: "name",
                    title: "Elimina tutto",
                    content: "Fate clic per eliminare tutte le informazioni statistiche della lista."
                }
            ]
        },
        SYSTEM_PARA_WIRELESS: {
            TITLE: "Wireless 2.4GHz/5GHz",
            CONTENT: [
                {
                    type: "name",
                    title: "Intervallo Beacon",
                    content: "Immettete un valore compreso tra 40 e 1000 millisecondi per determinare l'intervallo di tempo di invio dei pacchetti beacon trasmessi dal router per sincronizzare la rete wireless. Il valore di default è 100 millisecondi."
                }, {
                    type: "name",
                    title: "Soglia RTS",
                    content: "Immettete un valore compreso tra 1 e 2346 per determinare la dimensione dei pacchetti trasmessi tramite il router. Di default, la dimensione soglia RTS (Request to Send) è 2346. Se la dimensione del pacchetto è superiore alla soglia prefissata, il router invia i frame RTS a una particolare stazione ricevente e negozia l'invio di una frame dati, oppure il pacchetto verrà inviato immediatamente."
                }, {
                    type: "name",
                    title: "Intervallo DTIM",
                    content: "Questo valore determina l'intervallo DTIM (Delivery Traffic Indication Message). Immettete un valore compreso tra 1 e 15 millisecondi.  Il valore di default è 1 e indica che l'intervallo DTIM è uguale all'intervallo beacon."
                }, {
                    type: "name",
                    title: "Periodo Aggiornamento Chiavi di Gruppo",
                    content: "Immettete il numero di secondi (minimo 30) dell'intervallo di tempo per il rinnovo automatico della chiave di crittografia. Il valore di default è 0 e indica che le chiavi non vengono rinnovate."
                }, {
                    type: "name",
                    title: "Funzione WMM",
                    content: "La funzione WMM garantisce che i pacchetti con messaggi ad alta priorità vengano trasmessi prima degli altri. È abilitata per impostazione predefinita ed è altamente raccomandata."
                }, {
                    type: "name",
                    title: "Funzione Short GI",
                    content: "Questa funzione è abilitata per impostazione predefinita ed è raccomandata per aumentare la capacità di dati riducendo il tempo GI (Guard Interval)."
                }, {
                    type: "name",
                    title: "Funzione AP Isolation",
                    content: "Di default questa funzione è disabilitata. Se desiderate impedire a tutti i dispositivi wireless connessi in rete di interagire tra loro, rimanendo però in grado di accedere a Internet, selezionate la casella di controllo Abilita AP Isolation."
                }, {
                    type: "name",
                    title: "Bridge WDS",
                    content: "Abilitate la funzione Bridge WDS (Wireless Distribution System) per consentire al router di effettuare bridge con un altro access point (AP) in una rete locale wireless (WLAN). Se la funzione è abilitata, configurate quanto segue:",
                    children: [
                        {
                            type: "name",
                            title: "SSID",
                            content: "Immettete l'SSID del WAP (Wireless Access Point) a cui il router si connetterà come client o utilizzate la funzione Survey per trovare tutte le reti disponibili."
                        }, {
                            type: "name",
                            title: "Survey",
                            content: "Fate clic sul pulsante per eseguire la scansione e visualizzare SSID, BSSID, potenza del segnale, canale e informazioni di sicurezza di tutte le reti wireless disponibili. Una volta che avete selezionato una rete, i campi SSID, Indirizzo MAC e Sicurezza saranno popolati automaticamente."
                        }, {
                            type: "name",
                            title: "Indirizzo MAC (per connessione bridge)",
                            content: "Immettete l'indirizzo MAC (BSSID) composto da 12 caratteri esadecimali (0-9, a-f, A-F) separati da trattini dell'access point wireless a cui il router si connetterà come client. Se scegliete l'AP desiderato tramite la funzione Survey, il campo Indirizzo MAC viene popolato automaticamente."
                        }, {
                            type: "name",
                            title: "Sicurezza",
                            content: "Selezionate il tipo di sicurezza dell'access point tra Nessuna, WPA-PSK/WPA2-PSK o WEP. Se scegliete l'AP mediante Survey, il campo Sicurezza viene popolato automaticamente.",
                            children: [
                                {
                                    type: "name",
                                    title: "Password",
                                    content: "Questa opzione è disponibile se il tipo di sicurezza è WPA-PSK/WPA2-PSK o WEP. Immettete la password di sicurezza dell'access point selezionato."
                                }, {
                                    type: "name",
                                    title: "Tipo di autenticazione",
                                    content: "Questa opzione è disponibile solo se il tipo di sicurezza è WEP (Wired Equivalent Privacy). Selezionate il tipo di autenticazione appropriato (Auto, Open System o shared Key) utilizzato dal access point selezionato."
                                }, {
                                    type: "name",
                                    title: "Formato chiave WEP",
                                    content: "Questa opzione è disponibile solo se il tipo di sicurezza è WEP. Selezionate il formato della chiave (ASCII o esadecimale) utilizzato dall'AP selezionato."
                                }
                            ]
                        }
                    ]
                }, {
                    type: "paragraph",
                    content: "Fate clic su Salva per salvare tutte le impostazioni."
                }
            ]
        },
        SYSTEM_PARA_WPS: {
            TITLE: "WPS",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Selezionate la casella di controllo Abilita WPS e fate clic su Salva per abilitare la funzione WPS (Wi-Fi Protected Setup) che vi consente di connettervi facilmente a dispositivi con WPS abilitato premendo un pulsante."
                }
            ]
        },
        SYSTEM_PARA_NAT: {
            TITLE: "NAT",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Selezionate la casella di controllo Abilita NAT Boost e fate clic su Salva per abilitare la funzione  NAT (Network Address Translation)."
                }, {
                    type: "name",
                    title: "NAT Boost",
                    content: "Selezionate la casella di controllo Abilita NAT Boost e fate clic su Salva per assicurarvi che il vostro router abbia la banda migliore."
                }, {
                    type: "note",
                    title: "Nota",
                    content: "NAT Boost verrà disabilitato se sono abilitate QoS o Statistiche di Traffico."
                }
            ]
        },
        SYSTEM_PARA_DOS: {
            TITLE: "Impostazioni Livello Protezione DoS",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "The DoS Protection Level protects the router from TCP-SYN-Flood, UDP-Flood, and ICMP-Flood attacks."
                }, {
                    type: "name",
                    title: "Livello Pacchetti ICMP-FLOOD",
                    content: "Immettete un valore ICMP compreso tra 5 e 7200 pacchetti per attivare la protezione ICMP-FLOOD quando il numero di pacchetti supera il valore soglia prefissato."
                }, {
                    type: "name",
                    title: "Livello Pacchetti UDP-FLOOD",
                    content: "Immettete un valore UDP compreso tra 5 e 7200 pacchetti per attivare la protezione UDP-FLOOD quando il numero di pacchetti supera il valore soglia prefissato."
                }, {
                    type: "name",
                    title: "Livello Pacchetti TCP-FLOOD",
                    content: "Immettete un valore TCP-SYN compreso tra 5 e 7200 pacchetti per attivare la protezione TCP-SYN-FLOOD quando il numero di pacchetti supera il valore soglia prefissato."
                }, {
                    type: "paragraph",
                    content: "Fate clic su Salva per salvare tutte le impostazioni."
                }
            ]
        },
        SYSTEM_PARA_DUPLEX: {
            TITLE: "Duplex",
            CONTENT: [
                {
                    type: "name",
                    title: "Duplex",
                    content: "Selezionate il tipo duplex dall'elenco a discesa."
                }, {
                    type: "paragraph",
                    content: "Fate clic su Salva per salvare tutte le impostazioni."
                }
            ]
        },
        BASIC_NETWORK_INTEREST: {
            TITLE: "Internet",
            CONTENT: [
                {
                    type: "name",
                    title: "Stato Internet",
                    content: "Mostra lo stato corrente della connessione Internet del router."
                }, {
                    type: "name",
                    title: "Tipo Connessione",
                    content: "Mostra il tipo di connessione Internet."
                }, {
                    type: "name",
                    title: "Indirizzo IP",
                    content: "Mostra l'indirizzo IP Internet corrente assegnato al router."
                }, {
                    type: "name",
                    title: "Connessione Secondaria/Indirizzo IP",
                    content: "Mostra il tipo di connessione secondaria e l'indirizzo IP."
                }
            ]
        },
        BASIC_NETWORK_ROUTER: {
            TITLE: "Router",
            CONTENT: [
                {
                    type: "title",
                    title: "Wireless 2.4GHz/5GHz"
                }, {
                    type: "name",
                    title: "SSID",
                    content: "Mostra il nome della rete wireless corrente della frequenza 2.4GHz/5GHz."
                }, {
                    type: "name",
                    title: "Canale",
                    content: "Mostra il canale dalla rete wireless 2.4GHz/5GHz."
                }, {
                    type: "name",
                    title: "MAC",
                    content: "Mostra l'indirizzo MAC corrente della rete wireless 2.4GHz/5GHz."
                }, {
                    type: "title",
                    title: "Rete Ospiti 2.4GHz/5GHz"
                }, {
                    type: "name",
                    title: "Stato",
                    content: "Mostra se la Rete Ospiti wireless 2,4 GHz/5 GHz è abilitata o disabilitata."
                }, {
                    type: "name",
                    title: "SSID",
                    content: "Mostra il nome di rete wireless della Rete Ospiti."
                }
            ]
        },
        BASIC_NETWORK_CLIENTS: {
            TITLE: "Client Wireless/Cablati",
            CONTENT: [
                {
                    type: "name",
                    title: "Nome",
                    content: "Mostra il nome del client connesso al router."
                }, {
                    type: "name",
                    title: "Indirizzo IP",
                    content: "Mostra l'indirizzo IP assegnato al client."
                }, {
                    type: "name",
                    title: "Indirizzo MAC",
                    content: "Mostra l'indirizzo MAC del client."
                }
            ]
        },
        BASIC_NETWORK_PRINTER: {
            TITLE: "Stampante",
            CONTENT: [
                {
                    type: "name",
                    title: "Nome",
                    content: "Mostra il nome della stampante collegata al router tramite la porta USB."
                }
            ]
        },
        BASIC_NETWORK_USB: {
            TITLE: "Memoria USB",
            CONTENT: [
                {
                    type: "name",
                    title: "Disco USB",
                    content: "Mostra il nome del disco USB collegato al router."
                }, {
                    type: "name",
                    title: "Totale",
                    content: "Mostra la capacità totale del dispositivo di storage USB collegato."
                }, {
                    type: "name",
                    title: "Disponibile",
                    content: "Mostra la capacità disponibile del dispositivo di storage USB collegato."
                }
            ]
        },
        BASIC_INTERNET: {
            TITLE: "Internet",
            CONTENT: [
                {
                    type: "name",
                    title: "Rilevamento Automatico",
                    content: "Fate clic sul pulsante per fare in modo che il router rilevi automaticamente il tipo di connessione Internet corrente."
                }, {
                    type: "note",
                    title: "Nota",
                    content: "Se non siete sicuri del tipo di connessione Internet, utilizzate la funzione Rilevamento Automatico o contattate il vostro ISP per assistenza."
                }, {
                    type: "title",
                    title: "Tipo di connessione Internet: IP statico"
                }, {
                    type: "name",
                    title: "Indirizzo IP/Subnet Mask/Gateway Predefinito/DNS primario/DNS secondario",
                    content: "Immettete le informazioni fornite dall'ISP."
                }, {
                    type: "title",
                    title: "Tipo di connessione Internet: IP dinamico"
                }, {
                    type: "name",
                    title: "NON clonare indirizzo MAC/Clona indirizzo MAC del computer corrente",
                    content: "Selezionate se volete o meno clonare il vostro indirizzo MAC, in base al vostro ISP."
                }, {
                    type: "title",
                    title: "Tipo di connessione Internet: PPPoE"
                }, {
                    type: "name",
                    title: "Nome utente/password",
                    content: "Immettete nome utente e password forniti dall'ISP. I campi fanno distinzione tra maiuscole e minuscole."
                }, {
                    type: "title",
                    title: "Tipo di connessione Internet: L2TP/PPTP"
                }, {
                    type: "name",
                    title: "Username/Password",
                    content: "Immettete nome utente e password forniti dall'ISP. I campi fanno distinzione tra maiuscole e minuscole."
                }, {
                    type: "name",
                    title: "Connessione secondaria (IP dinamico o statico)",
                    children: [
                        {
                            type: "name",
                            title: "IP Dinamico",
                            content: "Selezionate se indirizzo IP e subnet mask vengono assegnati automaticamente dall'ISP."
                        }, {
                            type: "name",
                            title: "IP Statico",
                            content: "Selezionate se indirizzo IP, subnet mask e indirizzi DNS sono forniti dall'ISP, e immettete le informazioni nei campi corrispondenti."
                        }
                    ]
                }, {
                    type: "name",
                    title: "IP/Nome Dominio Server VPN",
                    content: "Immettete l'indirizzo IP o il nome di dominio del server VPN fornito dall'ISP."
                }
            ]
        },
        BASIC_WIRELESS: {
            TITLE: " Impostazioni Wireless",
            CONTENT: [
                {
                    type: "name",
                    title: "Abilita Wireless",
                    content: "Selezionate la casella di controllo per abilitare il wireless 2,4GHz/5GHz."
                }, {
                    type: "name",
                    title: "Nome di Rete Wireless (SSID)",
                    content: "Potete lasciare il nome di rete wireless di default (SSID) o immetterne uno nuovo (fino a 32 caratteri). Il campo fa distinzione tra maiuscole e minuscole."
                }, {
                    type: "name",
                    title: "Nascondi SSID",
                    content: "Selezionate la casella se desiderate nascondere il nome di rete 2,4GHz/5GHz (SSID) nell'elenco delle reti wi-fi. "
                }, {
                    type: "name",
                    title: "Password",
                    content: "Immettete una password wireless composta di 8-63 caratteri ASCII, o 8-64 caratteri esadecimali. Il campo fa distinzione tra maiuscole e minuscole."
                }
            ]
        },
        BASIC_DEVICE_SETTINGS: {
            TITLE: "Impostazioni Dispositivo",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "La pagina Impostazioni Dispositivo visualizza le informazioni di qualsiasi dispositivo di storage USB collegato tramite la porta USB."
                }, {
                    type: "name",
                    title: "Analizza",
                    content: "Solitamente il router rileva automaticamente qualsiasi dispositivo una volta collegato. Se ciò non avviene, fate clic sul pulsante per eseguire l'analisi di ogni nuovo dispositivo connesso e aggiornare la pagina con le informazioni aggiornate."
                }, {
                    type: "name",
                    title: "Volume",
                    content: "Mostra il nome del volume USB."
                }, {
                    type: "name",
                    title: "Capacità",
                    content: "Mostra la capacità di storage totale del dispositivo USB."
                }, {
                    type: "name",
                    title: "Spazio libero",
                    content: "Mostra lo spazio di storage corrente disponibile."
                }, {
                    type: "name",
                    title: "Rimozione Sicura",
                    content: "Fate clic sul pulsante per smontare in modo sicuro il dispositivo di storage USB prima di scollegarlo fisicamente dal router.",
                    children: [
                        {
                            type: "paragraph",
                            content: "Il pulsante Rimozione Sicura appare solo quando vi è un dispositivo di storage USB collegato al router, e non sarà possibile smontare il dispositivo USB mentre il volume corrente è occupato."
                        }
                    ]
                }, {
                    type: "name",
                    title: "Attivo",
                    content: "Questa casella di controllo appare solo quando vi è un dispositivo di storage USB collegato al router. Selezionate per abilitare la condivisione di file del dispositivo USB."
                }
            ]
        },
        BASIC_SHARING_SETTINGS: {
            TITLE: "Impostazioni Condivisione",
            CONTENT: [
                {
                    type: "name",
                    title: "Rete/Nome server multimediale",
                    content: "Mostra il nome utilizzato per accedere al dispositivo di storage USB collegato."
                }
            ]
        },
        BASIC_FOLDER_SHARING: {
            TITLE: "Cartella Condivisione",
            CONTENT: [
                {
                    type: "name",
                    title: "Condividi Tutto",
                    content: "Attivate per condividere tutti i file e le cartelle o disattivate per condividere solo le cartelle selezionate."
                }, {
                    type: "name",
                    title: "Abilita Autenticazione",
                    content: "Vi consigliamo di abilitare l'autenticazione per richiedere agli utenti di immettere un nome utente e una password per accedere alle cartelle di condivisione."
                }, {
                    type: "name",
                    title: "Nome Cartella",
                    content: "Mostra il nome della cartella condivisa."
                }, {
                    type: "name",
                    title: "Percorso Cartella",
                    content: "Mostra il percorso della cartella condivisa."
                }, {
                    type: "name",
                    title: "Condivisione File",
                    content: "Indica se la cartella condivisa può essere utilizzata o meno per la condivisione di file multimediali."
                }, {
                    type: "name",
                    title: "Nome Volume",
                    content: "Mostra il nome del volume condiviso."
                }, {
                    type: "name",
                    title: "Stato",
                    content: "Mostra lo stato della cartella condivisa per mezzo dell'indicatore lampadina. Verde (Acceso) è abilitato e Grigio (Spento) è disabilitato. Potete abilitare o disabilitare facendo clic sul bulbo."
                }, {
                    type: "name",
                    title: "Modifica",
                    content: "Mostra le opzioni per modificare o eliminare la cartella condivisa corrispondente."
                }, {
                    type: "name",
                    title: "Aggiungi",
                    content: "Fate clic sul pulsante per creare una nuova voce."
                }, {
                    type: "name",
                    title: "Elimina",
                    content: "Fate clic sul pulsante per rimuovere la voce selezionata dalla tabella."
                }, {
                    type: "name",
                    title: "Sfoglia",
                    content: "Fate clic per cercare una cartella condivisa."
                }, {
                    type: "name",
                    title: "Consenti Accesso a Rete Ospiti",
                    content: "Selezionate per consentire ai client della rete ospiti l'accesso alle cartelle condivise."
                }, {
                    type: "name",
                    title: "Abilita Autenticazione",
                    content: "Selezionate per richiedere agli utenti l'accesso alle cartelle condivise con nome utente e password."
                }, {
                    type: "name",
                    title: "Attiva Accesso in Scrittura",
                    content: "Selezionate per consentire agli utenti di apportare modifiche al contenuto della cartella."
                }, {
                    type: "name",
                    title: "Attiva Condivisione File",
                    content: "Selezionate per abilitare la condivisione multimediale."
                }
            ]
        },
        BASIC_PRINT_SERVER: {
            TITLE: "Print Server",
            CONTENT: [
                {
                    type: "name",
                    title: "Abilita Print Server",
                    content: "Fate clic su On per abilitare la funzione print server."
                }, {
                    type: "name",
                    title: "Nome stampante",
                    content: "Mostra il nome della stampante collegata al router."
                }, {
                    type: "step",
                    title: "Imposta un Print Server che può essere utilizzato nella rete",
                    content: ["1.Collegate una stampante USB alla porta USB del router tramite un cavo USB.", "2.	Instllaate i driver della stampante sul vostro computer. Consultate il manuale del computer per eventuali istruzioni.", "3.Installate la Utility TP-LINK USB Printer Controller che potete scaricare (per Windows e Mac OS X) dal sito web ufficiale di TP-LINK."]
                }
            ]
        },
        BASIC_PARENTAL_CONTROL: {
            TITLE: "Parental Control",
            CONTENT: [
                {
                    type: "name",
                    title: "Stato",
                    content: "Attivate per abilitare la funzione Parental Control. Il Parental Control di default è disattivato."
                }
            ]
        },
        BASIC_PARENTAL_DEVICE: {
            TITLE: "Dispositivi Sotto Parental Control",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Mostra l'elenco dei dispositivi sottoposti al Parental Control."
                }, {
                    type: "name",
                    title: "Nome Dispositivo",
                    content: "Mostra il nome di tutti i dispositivi client connessi che sono attualmente sottoposti al Parental Control."
                }, {
                    type: "name",
                    title: "Indirizzo MAC",
                    content: "Mostra l'indirizzo MAC di tutti i dispositivi client connessi che sono attualmente sottoposti al Parental Control."
                }, {
                    type: "name",
                    title: "Tempo d'accesso a Internet",
                    content: "Mostra i periodi di tempo durante i quali sono attive le restrizioni."
                }, {
                    type: "name",
                    title: "Descrizione",
                    content: "Mostra una breve descrizione del dispositivo connesso. Si tratta di un'impostazione facoltativa."
                }, {
                    type: "name",
                    title: "Stato",
                    content: "Mostra lo stato corrente (abilitato o disabilitato) del Parental Control del dispositivo corrispondente."
                }, {
                    type: "name",
                    title: "Modifica",
                    content: "Mostra le opzioni per modificare o eliminare il dispositivo corrispondente."
                }, {
                    type: "step",
                    title: "Per limitare un nuovo dispositivo client",
                    content: [
                        "1. Fate clic su Aggiungi.",
                        "2. Fate clic su Mostra Dispositivi Esistenti e scegliete un dispositivo attualmente collegato dall'Elenco Dispositivi di Accesso; oppure, immettete il nome del dispositivo e l'indirizzo MAC manualmente per aggiungere un dispositivo non collegato.",
                        "3. Fate clic sull'icona Tempo di Accesso a Internet per specificare un periodo di tempo durante il quale si applicherà la restrizione.",
                        "4. Immettete una breve descrizione nel campo Descrizione (facoltativo).",
                        "5. Selezionate Abilita.",
                        "6. Fate clic su OK per salvare la voce."
                    ]
                }, {
                    type: "paragraph",
                    content: "Per modificare o eliminare una voce del Parental Control, fate clic su Modifica per modificare le informazioni o su Cestino per rimuovere la voce corrispondente."
                }, {
                    type: "paragraph",
                    content: "Per eliminare più voci, selezionate tutte le voci e fate clic su Elimina, sopra la tabella."
                }
            ]
        },
        BASIC_GUEST_NETWORK: {
            TITLE: "Rete Ospiti",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "La Rete Ospiti consente di impostare una rete separata con nome di rete wireless (SSID) e password dedicati che gli ospiti possono utilizzare per accedere alla rete wireless."
                }, {
                    type: "name",
                    title: "Consenti agli ospiti di vedersi fra loro",
                    content: "Selezionate la casella di controllo per consentire ai dispositivi wireless sulla Rete Ospiti di vedersi fra loro."
                }, {
                    type: "name",
                    title: "Consenti agli ospiti di accedere alla rete locale",
                    content: "Selezionate questa opzione per evitare che gli ospiti possano accedere all'interfaccia di gestione web."
                }, {
                    type: "name",
                    title: "Abilita Rete Ospiti",
                    content: "Selezionate la casella di controllo per abilitare la Rete Ospiti 2.4GHz/5GHz."
                }, {
                    type: "name",
                    title: "Nome Rete Wireless (SSID)",
                    content: "Utilizzate lo SSID Ospiti di default o create un nuovo nome (fino a 32 caratteri)."
                }, {
                    type: "name",
                    title: "Nascondi SSID",
                    content: "Selezionate la casella di controllo se desiderate nascondere lo SSID Ospiti dall'elenco delle reti Wi-Fi."
                }, {
                    type: "name",
                    title: "Password",
                    content: "Create una password composta da 8-63 caratteri ASCII o 8-64 caratteri esadecimali (0-9, a-f, A-F) per rendere sicura la Rete Ospiti."
                },
                ""
            ]
        },
        "": ""
    };
})(jQuery);
